/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CosmosDbMongoDbApiCollectionDataset
extends Dataset {
    private String type = "CosmosDbMongoDbApiCollection";
    private Object collection;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getCollection() {
        return this.collection;
    }

    public CosmosDbMongoDbApiCollectionDataset setCollection(Object collection) {
        this.collection = collection;
        return this;
    }

    @Override
    public CosmosDbMongoDbApiCollectionDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CosmosDbMongoDbApiCollectionDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public CosmosDbMongoDbApiCollectionDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public CosmosDbMongoDbApiCollectionDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public CosmosDbMongoDbApiCollectionDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public CosmosDbMongoDbApiCollectionDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public CosmosDbMongoDbApiCollectionDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.collection != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("collection", this.collection);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CosmosDbMongoDbApiCollectionDataset fromJson(JsonReader jsonReader) throws IOException {
        return (CosmosDbMongoDbApiCollectionDataset)jsonReader.readObject(reader -> {
            CosmosDbMongoDbApiCollectionDataset deserializedCosmosDbMongoDbApiCollectionDataset = new CosmosDbMongoDbApiCollectionDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiCollectionDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiCollectionDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiCollectionDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiCollectionDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedCosmosDbMongoDbApiCollectionDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedCosmosDbMongoDbApiCollectionDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiCollectionDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiCollectionDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("collection".equals(fieldName)) {
                            deserializedCosmosDbMongoDbApiCollectionDataset.collection = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCosmosDbMongoDbApiCollectionDataset.setAdditionalProperties(additionalProperties);
            return deserializedCosmosDbMongoDbApiCollectionDataset;
        });
    }
}

