/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Activity;
import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.AppendVariableActivity;
import com.azure.analytics.synapse.artifacts.models.ExecutePipelineActivity;
import com.azure.analytics.synapse.artifacts.models.FailActivity;
import com.azure.analytics.synapse.artifacts.models.FilterActivity;
import com.azure.analytics.synapse.artifacts.models.ForEachActivity;
import com.azure.analytics.synapse.artifacts.models.IfConditionActivity;
import com.azure.analytics.synapse.artifacts.models.SetVariableActivity;
import com.azure.analytics.synapse.artifacts.models.SwitchActivity;
import com.azure.analytics.synapse.artifacts.models.UntilActivity;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.analytics.synapse.artifacts.models.ValidationActivity;
import com.azure.analytics.synapse.artifacts.models.WaitActivity;
import com.azure.analytics.synapse.artifacts.models.WebHookActivity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ControlActivity
extends Activity {
    private String type = "Container";

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public ControlActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public ControlActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ControlActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public ControlActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ControlActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn(dependsOn);
        return this;
    }

    @Override
    public ControlActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties(userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ControlActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ControlActivity)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ControlActivity controlActivity;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ExecutePipeline".equals(discriminatorValue)) {
                    controlActivity = ExecutePipelineActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("IfCondition".equals(discriminatorValue)) {
                    controlActivity = IfConditionActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Switch".equals(discriminatorValue)) {
                    controlActivity = SwitchActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("ForEach".equals(discriminatorValue)) {
                    controlActivity = ForEachActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Wait".equals(discriminatorValue)) {
                    controlActivity = WaitActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Fail".equals(discriminatorValue)) {
                    controlActivity = FailActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Until".equals(discriminatorValue)) {
                    controlActivity = UntilActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Validation".equals(discriminatorValue)) {
                    controlActivity = ValidationActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("Filter".equals(discriminatorValue)) {
                    controlActivity = FilterActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("SetVariable".equals(discriminatorValue)) {
                    controlActivity = SetVariableActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("AppendVariable".equals(discriminatorValue)) {
                    controlActivity = AppendVariableActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                if ("WebHook".equals(discriminatorValue)) {
                    controlActivity = WebHookActivity.fromJson(readerToUse.reset());
                    return controlActivity;
                }
                controlActivity = ControlActivity.fromJsonKnownDiscriminator(readerToUse.reset());
                return controlActivity;
            }
        });
    }

    static ControlActivity fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ControlActivity)jsonReader.readObject(reader -> {
            ControlActivity deserializedControlActivity = new ControlActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedControlActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedControlActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedControlActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedControlActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedControlActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedControlActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedControlActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedControlActivity.setAdditionalProperties(additionalProperties);
            return deserializedControlActivity;
        });
    }
}

