/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.MultiplePipelineTrigger;
import com.azure.analytics.synapse.artifacts.models.TriggerPipelineReference;
import com.azure.analytics.synapse.artifacts.models.TriggerRuntimeState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BlobTrigger
extends MultiplePipelineTrigger {
    private String type = "BlobTrigger";
    private String folderPath;
    private int maxConcurrency;
    private LinkedServiceReference linkedService;

    @Override
    public String getType() {
        return this.type;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public BlobTrigger setFolderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public BlobTrigger setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public LinkedServiceReference getLinkedService() {
        return this.linkedService;
    }

    public BlobTrigger setLinkedService(LinkedServiceReference linkedService) {
        this.linkedService = linkedService;
        return this;
    }

    @Override
    public BlobTrigger setPipelines(List<TriggerPipelineReference> pipelines) {
        super.setPipelines(pipelines);
        return this;
    }

    @Override
    public BlobTrigger setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public BlobTrigger setAnnotations(List<Object> annotations) {
        super.setAnnotations((List)annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("pipelines", this.getPipelines(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStartObject("typeProperties");
        jsonWriter.writeStringField("folderPath", this.folderPath);
        jsonWriter.writeIntField("maxConcurrency", this.maxConcurrency);
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.linkedService);
        jsonWriter.writeEndObject();
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static BlobTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (BlobTrigger)jsonReader.readObject(reader -> {
            BlobTrigger deserializedBlobTrigger = new BlobTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedBlobTrigger.setDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedBlobTrigger.setRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedBlobTrigger.setAnnotations(annotations);
                    continue;
                }
                if ("pipelines".equals(fieldName)) {
                    List pipelines = reader.readArray(reader1 -> TriggerPipelineReference.fromJson(reader1));
                    deserializedBlobTrigger.setPipelines(pipelines);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBlobTrigger.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("folderPath".equals(fieldName)) {
                            deserializedBlobTrigger.folderPath = reader.getString();
                            continue;
                        }
                        if ("maxConcurrency".equals(fieldName)) {
                            deserializedBlobTrigger.maxConcurrency = reader.getInt();
                            continue;
                        }
                        if ("linkedService".equals(fieldName)) {
                            deserializedBlobTrigger.linkedService = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedBlobTrigger.setAdditionalProperties(additionalProperties);
            return deserializedBlobTrigger;
        });
    }
}

