/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BlobSource
extends CopySource {
    private String type = "BlobSource";
    private Object treatEmptyAsNull;
    private Object skipHeaderLineCount;
    private Object recursive;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getTreatEmptyAsNull() {
        return this.treatEmptyAsNull;
    }

    public BlobSource setTreatEmptyAsNull(Object treatEmptyAsNull) {
        this.treatEmptyAsNull = treatEmptyAsNull;
        return this;
    }

    public Object getSkipHeaderLineCount() {
        return this.skipHeaderLineCount;
    }

    public BlobSource setSkipHeaderLineCount(Object skipHeaderLineCount) {
        this.skipHeaderLineCount = skipHeaderLineCount;
        return this;
    }

    public Object getRecursive() {
        return this.recursive;
    }

    public BlobSource setRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    @Override
    public BlobSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public BlobSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public BlobSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.treatEmptyAsNull != null) {
            jsonWriter.writeUntypedField("treatEmptyAsNull", this.treatEmptyAsNull);
        }
        if (this.skipHeaderLineCount != null) {
            jsonWriter.writeUntypedField("skipHeaderLineCount", this.skipHeaderLineCount);
        }
        if (this.recursive != null) {
            jsonWriter.writeUntypedField("recursive", this.recursive);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static BlobSource fromJson(JsonReader jsonReader) throws IOException {
        return (BlobSource)jsonReader.readObject(reader -> {
            BlobSource deserializedBlobSource = new BlobSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedBlobSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedBlobSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedBlobSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBlobSource.type = reader.getString();
                    continue;
                }
                if ("treatEmptyAsNull".equals(fieldName)) {
                    deserializedBlobSource.treatEmptyAsNull = reader.readUntyped();
                    continue;
                }
                if ("skipHeaderLineCount".equals(fieldName)) {
                    deserializedBlobSource.skipHeaderLineCount = reader.readUntyped();
                    continue;
                }
                if ("recursive".equals(fieldName)) {
                    deserializedBlobSource.recursive = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedBlobSource.setAdditionalProperties(additionalProperties);
            return deserializedBlobSource;
        });
    }
}

