/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.AzureStorageLinkedServiceTypeProperties;
import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureTableStorageLinkedServiceTypeProperties
extends AzureStorageLinkedServiceTypeProperties {
    private Object serviceEndpoint;
    private CredentialReference credential;

    public Object getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public AzureTableStorageLinkedServiceTypeProperties setServiceEndpoint(Object serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureTableStorageLinkedServiceTypeProperties setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureTableStorageLinkedServiceTypeProperties setConnectionString(Object connectionString) {
        super.setConnectionString(connectionString);
        return this;
    }

    @Override
    public AzureTableStorageLinkedServiceTypeProperties setAccountKey(AzureKeyVaultSecretReference accountKey) {
        super.setAccountKey(accountKey);
        return this;
    }

    @Override
    public AzureTableStorageLinkedServiceTypeProperties setSasUri(Object sasUri) {
        super.setSasUri(sasUri);
        return this;
    }

    @Override
    public AzureTableStorageLinkedServiceTypeProperties setSasToken(AzureKeyVaultSecretReference sasToken) {
        super.setSasToken(sasToken);
        return this;
    }

    @Override
    public AzureTableStorageLinkedServiceTypeProperties setEncryptedCredential(String encryptedCredential) {
        super.setEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getConnectionString() != null) {
            jsonWriter.writeUntypedField("connectionString", this.getConnectionString());
        }
        jsonWriter.writeJsonField("accountKey", (JsonSerializable)this.getAccountKey());
        if (this.getSasUri() != null) {
            jsonWriter.writeUntypedField("sasUri", this.getSasUri());
        }
        jsonWriter.writeJsonField("sasToken", (JsonSerializable)this.getSasToken());
        jsonWriter.writeStringField("encryptedCredential", this.getEncryptedCredential());
        if (this.serviceEndpoint != null) {
            jsonWriter.writeUntypedField("serviceEndpoint", this.serviceEndpoint);
        }
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureTableStorageLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureTableStorageLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureTableStorageLinkedServiceTypeProperties deserializedAzureTableStorageLinkedServiceTypeProperties = new AzureTableStorageLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.setConnectionString(reader.readUntyped());
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.setAccountKey(AzureKeyVaultSecretReference.fromJson(reader));
                    continue;
                }
                if ("sasUri".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.setSasUri(reader.readUntyped());
                    continue;
                }
                if ("sasToken".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.setSasToken(AzureKeyVaultSecretReference.fromJson(reader));
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.setEncryptedCredential(reader.getString());
                    continue;
                }
                if ("serviceEndpoint".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.serviceEndpoint = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureTableStorageLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureTableStorageLinkedServiceTypeProperties;
        });
    }
}

