/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureTableSource
extends TabularSource {
    private String type = "AzureTableSource";
    private Object azureTableSourceQuery;
    private Object azureTableSourceIgnoreTableNotFound;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getAzureTableSourceQuery() {
        return this.azureTableSourceQuery;
    }

    public AzureTableSource setAzureTableSourceQuery(Object azureTableSourceQuery) {
        this.azureTableSourceQuery = azureTableSourceQuery;
        return this;
    }

    public Object getAzureTableSourceIgnoreTableNotFound() {
        return this.azureTableSourceIgnoreTableNotFound;
    }

    public AzureTableSource setAzureTableSourceIgnoreTableNotFound(Object azureTableSourceIgnoreTableNotFound) {
        this.azureTableSourceIgnoreTableNotFound = azureTableSourceIgnoreTableNotFound;
        return this;
    }

    @Override
    public AzureTableSource setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public AzureTableSource setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public AzureTableSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AzureTableSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AzureTableSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.azureTableSourceQuery != null) {
            jsonWriter.writeUntypedField("azureTableSourceQuery", this.azureTableSourceQuery);
        }
        if (this.azureTableSourceIgnoreTableNotFound != null) {
            jsonWriter.writeUntypedField("azureTableSourceIgnoreTableNotFound", this.azureTableSourceIgnoreTableNotFound);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureTableSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureTableSource)jsonReader.readObject(reader -> {
            AzureTableSource deserializedAzureTableSource = new AzureTableSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAzureTableSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAzureTableSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureTableSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedAzureTableSource.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedAzureTableSource.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureTableSource.type = reader.getString();
                    continue;
                }
                if ("azureTableSourceQuery".equals(fieldName)) {
                    deserializedAzureTableSource.azureTableSourceQuery = reader.readUntyped();
                    continue;
                }
                if ("azureTableSourceIgnoreTableNotFound".equals(fieldName)) {
                    deserializedAzureTableSource.azureTableSourceIgnoreTableNotFound = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureTableSource.setAdditionalProperties(additionalProperties);
            return deserializedAzureTableSource;
        });
    }
}

