/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.AzureSqlDWAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureSqlDWLinkedService
extends LinkedService {
    private String type = "AzureSqlDW";
    private Object server;
    private Object database;
    private Object encrypt;
    private Object trustServerCertificate;
    private Object hostNameInCertificate;
    private Object applicationIntent;
    private Object connectTimeout;
    private Object connectRetryCount;
    private Object connectRetryInterval;
    private Object loadBalanceTimeout;
    private Object commandTimeout;
    private Object integratedSecurity;
    private Object failoverPartner;
    private Object maxPoolSize;
    private Object minPoolSize;
    private Object multipleActiveResultSets;
    private Object multiSubnetFailover;
    private Object packetSize;
    private Object pooling;
    private Object connectionString;
    private AzureSqlDWAuthenticationType authenticationType;
    private Object userName;
    private AzureKeyVaultSecretReference password;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private Object tenant;
    private Object azureCloudType;
    private Object encryptedCredential;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getServer() {
        return this.server;
    }

    public AzureSqlDWLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public AzureSqlDWLinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object getEncrypt() {
        return this.encrypt;
    }

    public AzureSqlDWLinkedService setEncrypt(Object encrypt) {
        this.encrypt = encrypt;
        return this;
    }

    public Object getTrustServerCertificate() {
        return this.trustServerCertificate;
    }

    public AzureSqlDWLinkedService setTrustServerCertificate(Object trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
        return this;
    }

    public Object getHostNameInCertificate() {
        return this.hostNameInCertificate;
    }

    public AzureSqlDWLinkedService setHostNameInCertificate(Object hostNameInCertificate) {
        this.hostNameInCertificate = hostNameInCertificate;
        return this;
    }

    public Object getApplicationIntent() {
        return this.applicationIntent;
    }

    public AzureSqlDWLinkedService setApplicationIntent(Object applicationIntent) {
        this.applicationIntent = applicationIntent;
        return this;
    }

    public Object getConnectTimeout() {
        return this.connectTimeout;
    }

    public AzureSqlDWLinkedService setConnectTimeout(Object connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Object getConnectRetryCount() {
        return this.connectRetryCount;
    }

    public AzureSqlDWLinkedService setConnectRetryCount(Object connectRetryCount) {
        this.connectRetryCount = connectRetryCount;
        return this;
    }

    public Object getConnectRetryInterval() {
        return this.connectRetryInterval;
    }

    public AzureSqlDWLinkedService setConnectRetryInterval(Object connectRetryInterval) {
        this.connectRetryInterval = connectRetryInterval;
        return this;
    }

    public Object getLoadBalanceTimeout() {
        return this.loadBalanceTimeout;
    }

    public AzureSqlDWLinkedService setLoadBalanceTimeout(Object loadBalanceTimeout) {
        this.loadBalanceTimeout = loadBalanceTimeout;
        return this;
    }

    public Object getCommandTimeout() {
        return this.commandTimeout;
    }

    public AzureSqlDWLinkedService setCommandTimeout(Object commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public Object getIntegratedSecurity() {
        return this.integratedSecurity;
    }

    public AzureSqlDWLinkedService setIntegratedSecurity(Object integratedSecurity) {
        this.integratedSecurity = integratedSecurity;
        return this;
    }

    public Object getFailoverPartner() {
        return this.failoverPartner;
    }

    public AzureSqlDWLinkedService setFailoverPartner(Object failoverPartner) {
        this.failoverPartner = failoverPartner;
        return this;
    }

    public Object getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public AzureSqlDWLinkedService setMaxPoolSize(Object maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public Object getMinPoolSize() {
        return this.minPoolSize;
    }

    public AzureSqlDWLinkedService setMinPoolSize(Object minPoolSize) {
        this.minPoolSize = minPoolSize;
        return this;
    }

    public Object getMultipleActiveResultSets() {
        return this.multipleActiveResultSets;
    }

    public AzureSqlDWLinkedService setMultipleActiveResultSets(Object multipleActiveResultSets) {
        this.multipleActiveResultSets = multipleActiveResultSets;
        return this;
    }

    public Object getMultiSubnetFailover() {
        return this.multiSubnetFailover;
    }

    public AzureSqlDWLinkedService setMultiSubnetFailover(Object multiSubnetFailover) {
        this.multiSubnetFailover = multiSubnetFailover;
        return this;
    }

    public Object getPacketSize() {
        return this.packetSize;
    }

    public AzureSqlDWLinkedService setPacketSize(Object packetSize) {
        this.packetSize = packetSize;
        return this;
    }

    public Object getPooling() {
        return this.pooling;
    }

    public AzureSqlDWLinkedService setPooling(Object pooling) {
        this.pooling = pooling;
        return this;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public AzureSqlDWLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureSqlDWAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public AzureSqlDWLinkedService setAuthenticationType(AzureSqlDWAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public AzureSqlDWLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public AzureKeyVaultSecretReference getPassword() {
        return this.password;
    }

    public AzureSqlDWLinkedService setPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureSqlDWLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureSqlDWLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getServicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public AzureSqlDWLinkedService setServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public AzureSqlDWLinkedService setServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public AzureSqlDWLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getAzureCloudType() {
        return this.azureCloudType;
    }

    public AzureSqlDWLinkedService setAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureSqlDWLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureSqlDWLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureSqlDWLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureSqlDWLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureSqlDWLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureSqlDWLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureSqlDWLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.server != null || this.database != null || this.encrypt != null || this.trustServerCertificate != null || this.hostNameInCertificate != null || this.applicationIntent != null || this.connectTimeout != null || this.connectRetryCount != null || this.connectRetryInterval != null || this.loadBalanceTimeout != null || this.commandTimeout != null || this.integratedSecurity != null || this.failoverPartner != null || this.maxPoolSize != null || this.minPoolSize != null || this.multipleActiveResultSets != null || this.multiSubnetFailover != null || this.packetSize != null || this.pooling != null || this.connectionString != null || this.authenticationType != null || this.userName != null || this.password != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.servicePrincipalCredentialType != null || this.servicePrincipalCredential != null || this.tenant != null || this.azureCloudType != null || this.encryptedCredential != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.server != null) {
                jsonWriter.writeUntypedField("server", this.server);
            }
            if (this.database != null) {
                jsonWriter.writeUntypedField("database", this.database);
            }
            if (this.encrypt != null) {
                jsonWriter.writeUntypedField("encrypt", this.encrypt);
            }
            if (this.trustServerCertificate != null) {
                jsonWriter.writeUntypedField("trustServerCertificate", this.trustServerCertificate);
            }
            if (this.hostNameInCertificate != null) {
                jsonWriter.writeUntypedField("hostNameInCertificate", this.hostNameInCertificate);
            }
            if (this.applicationIntent != null) {
                jsonWriter.writeUntypedField("applicationIntent", this.applicationIntent);
            }
            if (this.connectTimeout != null) {
                jsonWriter.writeUntypedField("connectTimeout", this.connectTimeout);
            }
            if (this.connectRetryCount != null) {
                jsonWriter.writeUntypedField("connectRetryCount", this.connectRetryCount);
            }
            if (this.connectRetryInterval != null) {
                jsonWriter.writeUntypedField("connectRetryInterval", this.connectRetryInterval);
            }
            if (this.loadBalanceTimeout != null) {
                jsonWriter.writeUntypedField("loadBalanceTimeout", this.loadBalanceTimeout);
            }
            if (this.commandTimeout != null) {
                jsonWriter.writeUntypedField("commandTimeout", this.commandTimeout);
            }
            if (this.integratedSecurity != null) {
                jsonWriter.writeUntypedField("integratedSecurity", this.integratedSecurity);
            }
            if (this.failoverPartner != null) {
                jsonWriter.writeUntypedField("failoverPartner", this.failoverPartner);
            }
            if (this.maxPoolSize != null) {
                jsonWriter.writeUntypedField("maxPoolSize", this.maxPoolSize);
            }
            if (this.minPoolSize != null) {
                jsonWriter.writeUntypedField("minPoolSize", this.minPoolSize);
            }
            if (this.multipleActiveResultSets != null) {
                jsonWriter.writeUntypedField("multipleActiveResultSets", this.multipleActiveResultSets);
            }
            if (this.multiSubnetFailover != null) {
                jsonWriter.writeUntypedField("multiSubnetFailover", this.multiSubnetFailover);
            }
            if (this.packetSize != null) {
                jsonWriter.writeUntypedField("packetSize", this.packetSize);
            }
            if (this.pooling != null) {
                jsonWriter.writeUntypedField("pooling", this.pooling);
            }
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            if (this.servicePrincipalCredentialType != null) {
                jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
            }
            jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
            if (this.tenant != null) {
                jsonWriter.writeUntypedField("tenant", this.tenant);
            }
            if (this.azureCloudType != null) {
                jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureSqlDWLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSqlDWLinkedService)jsonReader.readObject(reader -> {
            AzureSqlDWLinkedService deserializedAzureSqlDWLinkedService = new AzureSqlDWLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureSqlDWLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureSqlDWLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("server".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("encrypt".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.encrypt = reader.readUntyped();
                            continue;
                        }
                        if ("trustServerCertificate".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.trustServerCertificate = reader.readUntyped();
                            continue;
                        }
                        if ("hostNameInCertificate".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.hostNameInCertificate = reader.readUntyped();
                            continue;
                        }
                        if ("applicationIntent".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.applicationIntent = reader.readUntyped();
                            continue;
                        }
                        if ("connectTimeout".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.connectTimeout = reader.readUntyped();
                            continue;
                        }
                        if ("connectRetryCount".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.connectRetryCount = reader.readUntyped();
                            continue;
                        }
                        if ("connectRetryInterval".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.connectRetryInterval = reader.readUntyped();
                            continue;
                        }
                        if ("loadBalanceTimeout".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.loadBalanceTimeout = reader.readUntyped();
                            continue;
                        }
                        if ("commandTimeout".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.commandTimeout = reader.readUntyped();
                            continue;
                        }
                        if ("integratedSecurity".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.integratedSecurity = reader.readUntyped();
                            continue;
                        }
                        if ("failoverPartner".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.failoverPartner = reader.readUntyped();
                            continue;
                        }
                        if ("maxPoolSize".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.maxPoolSize = reader.readUntyped();
                            continue;
                        }
                        if ("minPoolSize".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.minPoolSize = reader.readUntyped();
                            continue;
                        }
                        if ("multipleActiveResultSets".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.multipleActiveResultSets = reader.readUntyped();
                            continue;
                        }
                        if ("multiSubnetFailover".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.multiSubnetFailover = reader.readUntyped();
                            continue;
                        }
                        if ("packetSize".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.packetSize = reader.readUntyped();
                            continue;
                        }
                        if ("pooling".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.pooling = reader.readUntyped();
                            continue;
                        }
                        if ("connectionString".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.authenticationType = AzureSqlDWAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.password = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalCredentialType".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.servicePrincipalCredentialType = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalCredential".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.servicePrincipalCredential = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("azureCloudType".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.azureCloudType = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzureSqlDWLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureSqlDWLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureSqlDWLinkedService;
        });
    }
}

