/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzurePostgreSqlSinkUpsertSettings;
import com.azure.analytics.synapse.artifacts.models.AzurePostgreSqlWriteMethodEnum;
import com.azure.analytics.synapse.artifacts.models.CopySink;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzurePostgreSqlSink
extends CopySink {
    private String type = "AzurePostgreSqlSink";
    private Object preCopyScript;
    private AzurePostgreSqlWriteMethodEnum writeMethod;
    private AzurePostgreSqlSinkUpsertSettings upsertSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getPreCopyScript() {
        return this.preCopyScript;
    }

    public AzurePostgreSqlSink setPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public AzurePostgreSqlWriteMethodEnum getWriteMethod() {
        return this.writeMethod;
    }

    public AzurePostgreSqlSink setWriteMethod(AzurePostgreSqlWriteMethodEnum writeMethod) {
        this.writeMethod = writeMethod;
        return this;
    }

    public AzurePostgreSqlSinkUpsertSettings getUpsertSettings() {
        return this.upsertSettings;
    }

    public AzurePostgreSqlSink setUpsertSettings(AzurePostgreSqlSinkUpsertSettings upsertSettings) {
        this.upsertSettings = upsertSettings;
        return this;
    }

    @Override
    public AzurePostgreSqlSink setWriteBatchSize(Object writeBatchSize) {
        super.setWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public AzurePostgreSqlSink setWriteBatchTimeout(Object writeBatchTimeout) {
        super.setWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public AzurePostgreSqlSink setSinkRetryCount(Object sinkRetryCount) {
        super.setSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public AzurePostgreSqlSink setSinkRetryWait(Object sinkRetryWait) {
        super.setSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public AzurePostgreSqlSink setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getWriteBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.getWriteBatchSize());
        }
        if (this.getWriteBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.getWriteBatchTimeout());
        }
        if (this.getSinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.getSinkRetryCount());
        }
        if (this.getSinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.getSinkRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.preCopyScript != null) {
            jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        }
        jsonWriter.writeStringField("writeMethod", this.writeMethod == null ? null : this.writeMethod.toString());
        jsonWriter.writeJsonField("upsertSettings", (JsonSerializable)this.upsertSettings);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzurePostgreSqlSink fromJson(JsonReader jsonReader) throws IOException {
        return (AzurePostgreSqlSink)jsonReader.readObject(reader -> {
            AzurePostgreSqlSink deserializedAzurePostgreSqlSink = new AzurePostgreSqlSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedAzurePostgreSqlSink.setWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedAzurePostgreSqlSink.setWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedAzurePostgreSqlSink.setSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedAzurePostgreSqlSink.setSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzurePostgreSqlSink.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzurePostgreSqlSink.type = reader.getString();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedAzurePostgreSqlSink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("writeMethod".equals(fieldName)) {
                    deserializedAzurePostgreSqlSink.writeMethod = AzurePostgreSqlWriteMethodEnum.fromString(reader.getString());
                    continue;
                }
                if ("upsertSettings".equals(fieldName)) {
                    deserializedAzurePostgreSqlSink.upsertSettings = AzurePostgreSqlSinkUpsertSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzurePostgreSqlSink.setAdditionalProperties(additionalProperties);
            return deserializedAzurePostgreSqlSink;
        });
    }
}

