/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureMLUpdateResourceActivity
extends ExecutionActivity {
    private String type = "AzureMLUpdateResource";
    private Object trainedModelName;
    private LinkedServiceReference trainedModelLinkedServiceName;
    private Object trainedModelFilePath;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getTrainedModelName() {
        return this.trainedModelName;
    }

    public AzureMLUpdateResourceActivity setTrainedModelName(Object trainedModelName) {
        this.trainedModelName = trainedModelName;
        return this;
    }

    public LinkedServiceReference getTrainedModelLinkedServiceName() {
        return this.trainedModelLinkedServiceName;
    }

    public AzureMLUpdateResourceActivity setTrainedModelLinkedServiceName(LinkedServiceReference trainedModelLinkedServiceName) {
        this.trainedModelLinkedServiceName = trainedModelLinkedServiceName;
        return this;
    }

    public Object getTrainedModelFilePath() {
        return this.trainedModelFilePath;
    }

    public AzureMLUpdateResourceActivity setTrainedModelFilePath(Object trainedModelFilePath) {
        this.trainedModelFilePath = trainedModelFilePath;
        return this;
    }

    @Override
    public AzureMLUpdateResourceActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureMLUpdateResourceActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public AzureMLUpdateResourceActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public AzureMLUpdateResourceActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureMLUpdateResourceActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public AzureMLUpdateResourceActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public AzureMLUpdateResourceActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public AzureMLUpdateResourceActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.trainedModelName != null || this.trainedModelLinkedServiceName != null || this.trainedModelFilePath != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("trainedModelName", this.trainedModelName);
            jsonWriter.writeJsonField("trainedModelLinkedServiceName", (JsonSerializable)this.trainedModelLinkedServiceName);
            jsonWriter.writeUntypedField("trainedModelFilePath", this.trainedModelFilePath);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureMLUpdateResourceActivity fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLUpdateResourceActivity)jsonReader.readObject(reader -> {
            AzureMLUpdateResourceActivity deserializedAzureMLUpdateResourceActivity = new AzureMLUpdateResourceActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureMLUpdateResourceActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureMLUpdateResourceActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedAzureMLUpdateResourceActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedAzureMLUpdateResourceActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedAzureMLUpdateResourceActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedAzureMLUpdateResourceActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureMLUpdateResourceActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedAzureMLUpdateResourceActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureMLUpdateResourceActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("trainedModelName".equals(fieldName)) {
                            deserializedAzureMLUpdateResourceActivity.trainedModelName = reader.readUntyped();
                            continue;
                        }
                        if ("trainedModelLinkedServiceName".equals(fieldName)) {
                            deserializedAzureMLUpdateResourceActivity.trainedModelLinkedServiceName = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        if ("trainedModelFilePath".equals(fieldName)) {
                            deserializedAzureMLUpdateResourceActivity.trainedModelFilePath = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureMLUpdateResourceActivity.setAdditionalProperties(additionalProperties);
            return deserializedAzureMLUpdateResourceActivity;
        });
    }
}

