/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureFileStorageLinkedService
extends LinkedService {
    private String type = "AzureFileStorage";
    private Object host;
    private Object userId;
    private SecretBase password;
    private Object connectionString;
    private AzureKeyVaultSecretReference accountKey;
    private Object sasUri;
    private AzureKeyVaultSecretReference sasToken;
    private Object fileShare;
    private Object snapshot;
    private Object encryptedCredential;
    private Object serviceEndpoint;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getHost() {
        return this.host;
    }

    public AzureFileStorageLinkedService setHost(Object host) {
        this.host = host;
        return this;
    }

    public Object getUserId() {
        return this.userId;
    }

    public AzureFileStorageLinkedService setUserId(Object userId) {
        this.userId = userId;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public AzureFileStorageLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public AzureFileStorageLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference getAccountKey() {
        return this.accountKey;
    }

    public AzureFileStorageLinkedService setAccountKey(AzureKeyVaultSecretReference accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public Object getSasUri() {
        return this.sasUri;
    }

    public AzureFileStorageLinkedService setSasUri(Object sasUri) {
        this.sasUri = sasUri;
        return this;
    }

    public AzureKeyVaultSecretReference getSasToken() {
        return this.sasToken;
    }

    public AzureFileStorageLinkedService setSasToken(AzureKeyVaultSecretReference sasToken) {
        this.sasToken = sasToken;
        return this;
    }

    public Object getFileShare() {
        return this.fileShare;
    }

    public AzureFileStorageLinkedService setFileShare(Object fileShare) {
        this.fileShare = fileShare;
        return this;
    }

    public Object getSnapshot() {
        return this.snapshot;
    }

    public AzureFileStorageLinkedService setSnapshot(Object snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureFileStorageLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public AzureFileStorageLinkedService setServiceEndpoint(Object serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureFileStorageLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureFileStorageLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureFileStorageLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureFileStorageLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureFileStorageLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureFileStorageLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.host != null || this.userId != null || this.password != null || this.connectionString != null || this.accountKey != null || this.sasUri != null || this.sasToken != null || this.fileShare != null || this.snapshot != null || this.encryptedCredential != null || this.serviceEndpoint != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("host", this.host);
            if (this.userId != null) {
                jsonWriter.writeUntypedField("userId", this.userId);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            jsonWriter.writeJsonField("accountKey", (JsonSerializable)this.accountKey);
            if (this.sasUri != null) {
                jsonWriter.writeUntypedField("sasUri", this.sasUri);
            }
            jsonWriter.writeJsonField("sasToken", (JsonSerializable)this.sasToken);
            if (this.fileShare != null) {
                jsonWriter.writeUntypedField("fileShare", this.fileShare);
            }
            if (this.snapshot != null) {
                jsonWriter.writeUntypedField("snapshot", this.snapshot);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            if (this.serviceEndpoint != null) {
                jsonWriter.writeUntypedField("serviceEndpoint", this.serviceEndpoint);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureFileStorageLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFileStorageLinkedService)jsonReader.readObject(reader -> {
            AzureFileStorageLinkedService deserializedAzureFileStorageLinkedService = new AzureFileStorageLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureFileStorageLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureFileStorageLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("host".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.host = reader.readUntyped();
                            continue;
                        }
                        if ("userId".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.userId = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("connectionString".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("accountKey".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.accountKey = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("sasUri".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.sasUri = reader.readUntyped();
                            continue;
                        }
                        if ("sasToken".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.sasToken = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("fileShare".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.fileShare = reader.readUntyped();
                            continue;
                        }
                        if ("snapshot".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.snapshot = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("serviceEndpoint".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.serviceEndpoint = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzureFileStorageLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureFileStorageLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureFileStorageLinkedService;
        });
    }
}

