/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureDatabricksDeltaLakeImportCommand;
import com.azure.analytics.synapse.artifacts.models.CopySink;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureDatabricksDeltaLakeSink
extends CopySink {
    private String type = "AzureDatabricksDeltaLakeSink";
    private Object preCopyScript;
    private AzureDatabricksDeltaLakeImportCommand importSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getPreCopyScript() {
        return this.preCopyScript;
    }

    public AzureDatabricksDeltaLakeSink setPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public AzureDatabricksDeltaLakeImportCommand getImportSettings() {
        return this.importSettings;
    }

    public AzureDatabricksDeltaLakeSink setImportSettings(AzureDatabricksDeltaLakeImportCommand importSettings) {
        this.importSettings = importSettings;
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink setWriteBatchSize(Object writeBatchSize) {
        super.setWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink setWriteBatchTimeout(Object writeBatchTimeout) {
        super.setWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink setSinkRetryCount(Object sinkRetryCount) {
        super.setSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink setSinkRetryWait(Object sinkRetryWait) {
        super.setSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getWriteBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.getWriteBatchSize());
        }
        if (this.getWriteBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.getWriteBatchTimeout());
        }
        if (this.getSinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.getSinkRetryCount());
        }
        if (this.getSinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.getSinkRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.preCopyScript != null) {
            jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        }
        jsonWriter.writeJsonField("importSettings", (JsonSerializable)this.importSettings);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksDeltaLakeSink fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksDeltaLakeSink)jsonReader.readObject(reader -> {
            AzureDatabricksDeltaLakeSink deserializedAzureDatabricksDeltaLakeSink = new AzureDatabricksDeltaLakeSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.setWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.setWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.setSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.setSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.type = reader.getString();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("importSettings".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.importSettings = AzureDatabricksDeltaLakeImportCommand.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDatabricksDeltaLakeSink.setAdditionalProperties(additionalProperties);
            return deserializedAzureDatabricksDeltaLakeSink;
        });
    }
}

