/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureDatabricksDeltaLakeLinkedService
extends LinkedService {
    private String type = "AzureDatabricksDeltaLake";
    private Object domain;
    private SecretBase accessToken;
    private Object clusterId;
    private Object encryptedCredential;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getDomain() {
        return this.domain;
    }

    public AzureDatabricksDeltaLakeLinkedService setDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    public SecretBase getAccessToken() {
        return this.accessToken;
    }

    public AzureDatabricksDeltaLakeLinkedService setAccessToken(SecretBase accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public Object getClusterId() {
        return this.clusterId;
    }

    public AzureDatabricksDeltaLakeLinkedService setClusterId(Object clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureDatabricksDeltaLakeLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureDatabricksDeltaLakeLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.domain != null || this.accessToken != null || this.clusterId != null || this.encryptedCredential != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("domain", this.domain);
            jsonWriter.writeJsonField("accessToken", (JsonSerializable)this.accessToken);
            if (this.clusterId != null) {
                jsonWriter.writeUntypedField("clusterId", this.clusterId);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksDeltaLakeLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksDeltaLakeLinkedService)jsonReader.readObject(reader -> {
            AzureDatabricksDeltaLakeLinkedService deserializedAzureDatabricksDeltaLakeLinkedService = new AzureDatabricksDeltaLakeLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureDatabricksDeltaLakeLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureDatabricksDeltaLakeLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("domain".equals(fieldName)) {
                            deserializedAzureDatabricksDeltaLakeLinkedService.domain = reader.readUntyped();
                            continue;
                        }
                        if ("accessToken".equals(fieldName)) {
                            deserializedAzureDatabricksDeltaLakeLinkedService.accessToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("clusterId".equals(fieldName)) {
                            deserializedAzureDatabricksDeltaLakeLinkedService.clusterId = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureDatabricksDeltaLakeLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzureDatabricksDeltaLakeLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDatabricksDeltaLakeLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureDatabricksDeltaLakeLinkedService;
        });
    }
}

