/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DatasetLocation;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureBlobFSLocation
extends DatasetLocation {
    private String type = "AzureBlobFSLocation";
    private Object fileSystem;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getFileSystem() {
        return this.fileSystem;
    }

    public AzureBlobFSLocation setFileSystem(Object fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    @Override
    public AzureBlobFSLocation setFolderPath(Object folderPath) {
        super.setFolderPath(folderPath);
        return this;
    }

    @Override
    public AzureBlobFSLocation setFileName(Object fileName) {
        super.setFileName(fileName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getFolderPath() != null) {
            jsonWriter.writeUntypedField("folderPath", this.getFolderPath());
        }
        if (this.getFileName() != null) {
            jsonWriter.writeUntypedField("fileName", this.getFileName());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.fileSystem != null) {
            jsonWriter.writeUntypedField("fileSystem", this.fileSystem);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFSLocation fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFSLocation)jsonReader.readObject(reader -> {
            AzureBlobFSLocation deserializedAzureBlobFSLocation = new AzureBlobFSLocation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedAzureBlobFSLocation.setFolderPath(reader.readUntyped());
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedAzureBlobFSLocation.setFileName(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobFSLocation.type = reader.getString();
                    continue;
                }
                if ("fileSystem".equals(fieldName)) {
                    deserializedAzureBlobFSLocation.fileSystem = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobFSLocation.setAdditionalProperties(additionalProperties);
            return deserializedAzureBlobFSLocation;
        });
    }
}

