/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AppFiguresLinkedService
extends LinkedService {
    private String type = "AppFigures";
    private Object userName;
    private SecretBase password;
    private SecretBase clientKey;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getUserName() {
        return this.userName;
    }

    public AppFiguresLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public AppFiguresLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public SecretBase getClientKey() {
        return this.clientKey;
    }

    public AppFiguresLinkedService setClientKey(SecretBase clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    @Override
    public AppFiguresLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AppFiguresLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AppFiguresLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AppFiguresLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AppFiguresLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.userName != null || this.password != null || this.clientKey != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("userName", this.userName);
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            jsonWriter.writeJsonField("clientKey", (JsonSerializable)this.clientKey);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AppFiguresLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AppFiguresLinkedService)jsonReader.readObject(reader -> {
            AppFiguresLinkedService deserializedAppFiguresLinkedService = new AppFiguresLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAppFiguresLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAppFiguresLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAppFiguresLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAppFiguresLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAppFiguresLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAppFiguresLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("userName".equals(fieldName)) {
                            deserializedAppFiguresLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedAppFiguresLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("clientKey".equals(fieldName)) {
                            deserializedAppFiguresLinkedService.clientKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAppFiguresLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAppFiguresLinkedService;
        });
    }
}

