/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AmazonS3LinkedService
extends LinkedService {
    private String type = "AmazonS3";
    private Object authenticationType;
    private Object accessKeyId;
    private SecretBase secretAccessKey;
    private Object serviceUrl;
    private SecretBase sessionToken;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getAuthenticationType() {
        return this.authenticationType;
    }

    public AmazonS3LinkedService setAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getAccessKeyId() {
        return this.accessKeyId;
    }

    public AmazonS3LinkedService setAccessKeyId(Object accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    public SecretBase getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public AmazonS3LinkedService setSecretAccessKey(SecretBase secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
        return this;
    }

    public Object getServiceUrl() {
        return this.serviceUrl;
    }

    public AmazonS3LinkedService setServiceUrl(Object serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public SecretBase getSessionToken() {
        return this.sessionToken;
    }

    public AmazonS3LinkedService setSessionToken(SecretBase sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AmazonS3LinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public AmazonS3LinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AmazonS3LinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AmazonS3LinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AmazonS3LinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AmazonS3LinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.authenticationType != null || this.accessKeyId != null || this.secretAccessKey != null || this.serviceUrl != null || this.sessionToken != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.authenticationType != null) {
                jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
            }
            if (this.accessKeyId != null) {
                jsonWriter.writeUntypedField("accessKeyId", this.accessKeyId);
            }
            jsonWriter.writeJsonField("secretAccessKey", (JsonSerializable)this.secretAccessKey);
            if (this.serviceUrl != null) {
                jsonWriter.writeUntypedField("serviceUrl", this.serviceUrl);
            }
            jsonWriter.writeJsonField("sessionToken", (JsonSerializable)this.sessionToken);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonS3LinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonS3LinkedService)jsonReader.readObject(reader -> {
            AmazonS3LinkedService deserializedAmazonS3LinkedService = new AmazonS3LinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAmazonS3LinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAmazonS3LinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAmazonS3LinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAmazonS3LinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAmazonS3LinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonS3LinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("authenticationType".equals(fieldName)) {
                            deserializedAmazonS3LinkedService.authenticationType = reader.readUntyped();
                            continue;
                        }
                        if ("accessKeyId".equals(fieldName)) {
                            deserializedAmazonS3LinkedService.accessKeyId = reader.readUntyped();
                            continue;
                        }
                        if ("secretAccessKey".equals(fieldName)) {
                            deserializedAmazonS3LinkedService.secretAccessKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("serviceUrl".equals(fieldName)) {
                            deserializedAmazonS3LinkedService.serviceUrl = reader.readUntyped();
                            continue;
                        }
                        if ("sessionToken".equals(fieldName)) {
                            deserializedAmazonS3LinkedService.sessionToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAmazonS3LinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonS3LinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAmazonS3LinkedService;
        });
    }
}

