/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetCompression;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.DatasetStorageFormat;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AmazonS3Dataset
extends Dataset {
    private String type = "AmazonS3Object";
    private Object bucketName;
    private Object key;
    private Object prefix;
    private Object version;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;
    private DatasetStorageFormat format;
    private DatasetCompression compression;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getBucketName() {
        return this.bucketName;
    }

    public AmazonS3Dataset setBucketName(Object bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public Object getKey() {
        return this.key;
    }

    public AmazonS3Dataset setKey(Object key) {
        this.key = key;
        return this;
    }

    public Object getPrefix() {
        return this.prefix;
    }

    public AmazonS3Dataset setPrefix(Object prefix) {
        this.prefix = prefix;
        return this;
    }

    public Object getVersion() {
        return this.version;
    }

    public AmazonS3Dataset setVersion(Object version) {
        this.version = version;
        return this;
    }

    public Object getModifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public AmazonS3Dataset setModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object getModifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public AmazonS3Dataset setModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    public DatasetStorageFormat getFormat() {
        return this.format;
    }

    public AmazonS3Dataset setFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public DatasetCompression getCompression() {
        return this.compression;
    }

    public AmazonS3Dataset setCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    @Override
    public AmazonS3Dataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AmazonS3Dataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public AmazonS3Dataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public AmazonS3Dataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AmazonS3Dataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AmazonS3Dataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public AmazonS3Dataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.bucketName != null || this.key != null || this.prefix != null || this.version != null || this.modifiedDatetimeStart != null || this.modifiedDatetimeEnd != null || this.format != null || this.compression != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("bucketName", this.bucketName);
            if (this.key != null) {
                jsonWriter.writeUntypedField("key", this.key);
            }
            if (this.prefix != null) {
                jsonWriter.writeUntypedField("prefix", this.prefix);
            }
            if (this.version != null) {
                jsonWriter.writeUntypedField("version", this.version);
            }
            if (this.modifiedDatetimeStart != null) {
                jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
            }
            if (this.modifiedDatetimeEnd != null) {
                jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
            }
            jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
            jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonS3Dataset fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonS3Dataset)jsonReader.readObject(reader -> {
            AmazonS3Dataset deserializedAmazonS3Dataset = new AmazonS3Dataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAmazonS3Dataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAmazonS3Dataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedAmazonS3Dataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedAmazonS3Dataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAmazonS3Dataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAmazonS3Dataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedAmazonS3Dataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonS3Dataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("bucketName".equals(fieldName)) {
                            deserializedAmazonS3Dataset.bucketName = reader.readUntyped();
                            continue;
                        }
                        if ("key".equals(fieldName)) {
                            deserializedAmazonS3Dataset.key = reader.readUntyped();
                            continue;
                        }
                        if ("prefix".equals(fieldName)) {
                            deserializedAmazonS3Dataset.prefix = reader.readUntyped();
                            continue;
                        }
                        if ("version".equals(fieldName)) {
                            deserializedAmazonS3Dataset.version = reader.readUntyped();
                            continue;
                        }
                        if ("modifiedDatetimeStart".equals(fieldName)) {
                            deserializedAmazonS3Dataset.modifiedDatetimeStart = reader.readUntyped();
                            continue;
                        }
                        if ("modifiedDatetimeEnd".equals(fieldName)) {
                            deserializedAmazonS3Dataset.modifiedDatetimeEnd = reader.readUntyped();
                            continue;
                        }
                        if ("format".equals(fieldName)) {
                            deserializedAmazonS3Dataset.format = DatasetStorageFormat.fromJson(reader);
                            continue;
                        }
                        if ("compression".equals(fieldName)) {
                            deserializedAmazonS3Dataset.compression = DatasetCompression.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonS3Dataset.setAdditionalProperties(additionalProperties);
            return deserializedAmazonS3Dataset;
        });
    }
}

