/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SqlPartitionSettings;
import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AmazonRdsForSqlServerSource
extends TabularSource {
    private String type = "AmazonRdsForSqlServerSource";
    private Object sqlReaderQuery;
    private Object sqlReaderStoredProcedureName;
    private Object storedProcedureParameters;
    private Object isolationLevel;
    private Object produceAdditionalTypes;
    private Object partitionOption;
    private SqlPartitionSettings partitionSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getSqlReaderQuery() {
        return this.sqlReaderQuery;
    }

    public AmazonRdsForSqlServerSource setSqlReaderQuery(Object sqlReaderQuery) {
        this.sqlReaderQuery = sqlReaderQuery;
        return this;
    }

    public Object getSqlReaderStoredProcedureName() {
        return this.sqlReaderStoredProcedureName;
    }

    public AmazonRdsForSqlServerSource setSqlReaderStoredProcedureName(Object sqlReaderStoredProcedureName) {
        this.sqlReaderStoredProcedureName = sqlReaderStoredProcedureName;
        return this;
    }

    public Object getStoredProcedureParameters() {
        return this.storedProcedureParameters;
    }

    public AmazonRdsForSqlServerSource setStoredProcedureParameters(Object storedProcedureParameters) {
        this.storedProcedureParameters = storedProcedureParameters;
        return this;
    }

    public Object getIsolationLevel() {
        return this.isolationLevel;
    }

    public AmazonRdsForSqlServerSource setIsolationLevel(Object isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public Object getProduceAdditionalTypes() {
        return this.produceAdditionalTypes;
    }

    public AmazonRdsForSqlServerSource setProduceAdditionalTypes(Object produceAdditionalTypes) {
        this.produceAdditionalTypes = produceAdditionalTypes;
        return this;
    }

    public Object getPartitionOption() {
        return this.partitionOption;
    }

    public AmazonRdsForSqlServerSource setPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public SqlPartitionSettings getPartitionSettings() {
        return this.partitionSettings;
    }

    public AmazonRdsForSqlServerSource setPartitionSettings(SqlPartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AmazonRdsForSqlServerSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.sqlReaderQuery != null) {
            jsonWriter.writeUntypedField("sqlReaderQuery", this.sqlReaderQuery);
        }
        if (this.sqlReaderStoredProcedureName != null) {
            jsonWriter.writeUntypedField("sqlReaderStoredProcedureName", this.sqlReaderStoredProcedureName);
        }
        if (this.storedProcedureParameters != null) {
            jsonWriter.writeUntypedField("storedProcedureParameters", this.storedProcedureParameters);
        }
        if (this.isolationLevel != null) {
            jsonWriter.writeUntypedField("isolationLevel", this.isolationLevel);
        }
        if (this.produceAdditionalTypes != null) {
            jsonWriter.writeUntypedField("produceAdditionalTypes", this.produceAdditionalTypes);
        }
        if (this.partitionOption != null) {
            jsonWriter.writeUntypedField("partitionOption", this.partitionOption);
        }
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonRdsForSqlServerSource fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRdsForSqlServerSource)jsonReader.readObject(reader -> {
            AmazonRdsForSqlServerSource deserializedAmazonRdsForSqlServerSource = new AmazonRdsForSqlServerSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.type = reader.getString();
                    continue;
                }
                if ("sqlReaderQuery".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.sqlReaderQuery = reader.readUntyped();
                    continue;
                }
                if ("sqlReaderStoredProcedureName".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.sqlReaderStoredProcedureName = reader.readUntyped();
                    continue;
                }
                if ("storedProcedureParameters".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.storedProcedureParameters = reader.readUntyped();
                    continue;
                }
                if ("isolationLevel".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.isolationLevel = reader.readUntyped();
                    continue;
                }
                if ("produceAdditionalTypes".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.produceAdditionalTypes = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.partitionOption = reader.readUntyped();
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedAmazonRdsForSqlServerSource.partitionSettings = SqlPartitionSettings.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonRdsForSqlServerSource.setAdditionalProperties(additionalProperties);
            return deserializedAmazonRdsForSqlServerSource;
        });
    }
}

