/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AmazonRdsForOraclePartitionSettings;
import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AmazonRdsForOracleSource
extends CopySource {
    private String type = "AmazonRdsForOracleSource";
    private Object oracleReaderQuery;
    private Object queryTimeout;
    private Object partitionOption;
    private AmazonRdsForOraclePartitionSettings partitionSettings;
    private Object additionalColumns;
    private Object numberPrecision;
    private Object numberScale;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getOracleReaderQuery() {
        return this.oracleReaderQuery;
    }

    public AmazonRdsForOracleSource setOracleReaderQuery(Object oracleReaderQuery) {
        this.oracleReaderQuery = oracleReaderQuery;
        return this;
    }

    public Object getQueryTimeout() {
        return this.queryTimeout;
    }

    public AmazonRdsForOracleSource setQueryTimeout(Object queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public Object getPartitionOption() {
        return this.partitionOption;
    }

    public AmazonRdsForOracleSource setPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public AmazonRdsForOraclePartitionSettings getPartitionSettings() {
        return this.partitionSettings;
    }

    public AmazonRdsForOracleSource setPartitionSettings(AmazonRdsForOraclePartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    public Object getAdditionalColumns() {
        return this.additionalColumns;
    }

    public AmazonRdsForOracleSource setAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    public Object getNumberPrecision() {
        return this.numberPrecision;
    }

    public AmazonRdsForOracleSource setNumberPrecision(Object numberPrecision) {
        this.numberPrecision = numberPrecision;
        return this;
    }

    public Object getNumberScale() {
        return this.numberScale;
    }

    public AmazonRdsForOracleSource setNumberScale(Object numberScale) {
        this.numberScale = numberScale;
        return this;
    }

    @Override
    public AmazonRdsForOracleSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AmazonRdsForOracleSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AmazonRdsForOracleSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.oracleReaderQuery != null) {
            jsonWriter.writeUntypedField("oracleReaderQuery", this.oracleReaderQuery);
        }
        if (this.queryTimeout != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout);
        }
        if (this.partitionOption != null) {
            jsonWriter.writeUntypedField("partitionOption", this.partitionOption);
        }
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.numberPrecision != null) {
            jsonWriter.writeUntypedField("numberPrecision", this.numberPrecision);
        }
        if (this.numberScale != null) {
            jsonWriter.writeUntypedField("numberScale", this.numberScale);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonRdsForOracleSource fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRdsForOracleSource)jsonReader.readObject(reader -> {
            AmazonRdsForOracleSource deserializedAmazonRdsForOracleSource = new AmazonRdsForOracleSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.type = reader.getString();
                    continue;
                }
                if ("oracleReaderQuery".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.oracleReaderQuery = reader.readUntyped();
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.queryTimeout = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.partitionOption = reader.readUntyped();
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.partitionSettings = AmazonRdsForOraclePartitionSettings.fromJson(reader);
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if ("numberPrecision".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.numberPrecision = reader.readUntyped();
                    continue;
                }
                if ("numberScale".equals(fieldName)) {
                    deserializedAmazonRdsForOracleSource.numberScale = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonRdsForOracleSource.setAdditionalProperties(additionalProperties);
            return deserializedAmazonRdsForOracleSource;
        });
    }
}

