/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ActivityRun
implements JsonSerializable<ActivityRun> {
    private String pipelineName;
    private String pipelineRunId;
    private String activityName;
    private String activityType;
    private String activityRunId;
    private String linkedServiceName;
    private String status;
    private OffsetDateTime activityRunStart;
    private OffsetDateTime activityRunEnd;
    private Integer durationInMs;
    private Object input;
    private Object output;
    private Object error;
    private Map<String, Object> additionalProperties;

    public String getPipelineName() {
        return this.pipelineName;
    }

    public String getPipelineRunId() {
        return this.pipelineRunId;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public String getActivityRunId() {
        return this.activityRunId;
    }

    public String getLinkedServiceName() {
        return this.linkedServiceName;
    }

    public String getStatus() {
        return this.status;
    }

    public OffsetDateTime getActivityRunStart() {
        return this.activityRunStart;
    }

    public OffsetDateTime getActivityRunEnd() {
        return this.activityRunEnd;
    }

    public Integer getDurationInMs() {
        return this.durationInMs;
    }

    public Object getInput() {
        return this.input;
    }

    public Object getOutput() {
        return this.output;
    }

    public Object getError() {
        return this.error;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ActivityRun setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ActivityRun fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityRun)jsonReader.readObject(reader -> {
            ActivityRun deserializedActivityRun = new ActivityRun();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pipelineName".equals(fieldName)) {
                    deserializedActivityRun.pipelineName = reader.getString();
                    continue;
                }
                if ("pipelineRunId".equals(fieldName)) {
                    deserializedActivityRun.pipelineRunId = reader.getString();
                    continue;
                }
                if ("activityName".equals(fieldName)) {
                    deserializedActivityRun.activityName = reader.getString();
                    continue;
                }
                if ("activityType".equals(fieldName)) {
                    deserializedActivityRun.activityType = reader.getString();
                    continue;
                }
                if ("activityRunId".equals(fieldName)) {
                    deserializedActivityRun.activityRunId = reader.getString();
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedActivityRun.linkedServiceName = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedActivityRun.status = reader.getString();
                    continue;
                }
                if ("activityRunStart".equals(fieldName)) {
                    deserializedActivityRun.activityRunStart = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("activityRunEnd".equals(fieldName)) {
                    deserializedActivityRun.activityRunEnd = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("durationInMs".equals(fieldName)) {
                    deserializedActivityRun.durationInMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedActivityRun.input = reader.readUntyped();
                    continue;
                }
                if ("output".equals(fieldName)) {
                    deserializedActivityRun.output = reader.readUntyped();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedActivityRun.error = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedActivityRun.additionalProperties = additionalProperties;
            return deserializedActivityRun;
        });
    }
}

