/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.GitHubAccessTokenRequest;
import com.azure.analytics.synapse.artifacts.models.GitHubAccessTokenResponse;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class WorkspaceGitRepoManagementsImpl {
    private final WorkspaceGitRepoManagementsService service;
    private final ArtifactsClientImpl client;

    WorkspaceGitRepoManagementsImpl(ArtifactsClientImpl client) {
        this.service = (WorkspaceGitRepoManagementsService)RestProxy.create(WorkspaceGitRepoManagementsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GitHubAccessTokenResponse>> getGitHubAccessTokenWithResponseAsync(GitHubAccessTokenRequest gitHubAccessTokenRequest, String clientRequestId) {
        return FluxUtil.withContext(context -> this.getGitHubAccessTokenWithResponseAsync(gitHubAccessTokenRequest, clientRequestId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<GitHubAccessTokenResponse>> getGitHubAccessTokenWithResponseAsync(GitHubAccessTokenRequest gitHubAccessTokenRequest, String clientRequestId, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getGitHubAccessToken(this.client.getEndpoint(), clientRequestId, "2020-12-01", gitHubAccessTokenRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GitHubAccessTokenResponse> getGitHubAccessTokenAsync(GitHubAccessTokenRequest gitHubAccessTokenRequest, String clientRequestId) {
        return this.getGitHubAccessTokenWithResponseAsync(gitHubAccessTokenRequest, clientRequestId).flatMap(res -> Mono.justOrEmpty((Object)((GitHubAccessTokenResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GitHubAccessTokenResponse> getGitHubAccessTokenAsync(GitHubAccessTokenRequest gitHubAccessTokenRequest) {
        String clientRequestId = null;
        return this.getGitHubAccessTokenWithResponseAsync(gitHubAccessTokenRequest, clientRequestId).flatMap(res -> Mono.justOrEmpty((Object)((GitHubAccessTokenResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<GitHubAccessTokenResponse> getGitHubAccessTokenAsync(GitHubAccessTokenRequest gitHubAccessTokenRequest, String clientRequestId, Context context) {
        return this.getGitHubAccessTokenWithResponseAsync(gitHubAccessTokenRequest, clientRequestId, context).flatMap(res -> Mono.justOrEmpty((Object)((GitHubAccessTokenResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GitHubAccessTokenResponse> getGitHubAccessTokenWithResponse(GitHubAccessTokenRequest gitHubAccessTokenRequest, String clientRequestId, Context context) {
        return (Response)this.getGitHubAccessTokenWithResponseAsync(gitHubAccessTokenRequest, clientRequestId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public GitHubAccessTokenResponse getGitHubAccessToken(GitHubAccessTokenRequest gitHubAccessTokenRequest, String clientRequestId) {
        return (GitHubAccessTokenResponse)this.getGitHubAccessTokenWithResponse(gitHubAccessTokenRequest, clientRequestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public GitHubAccessTokenResponse getGitHubAccessToken(GitHubAccessTokenRequest gitHubAccessTokenRequest) {
        String clientRequestId = null;
        return (GitHubAccessTokenResponse)this.getGitHubAccessTokenWithResponse(gitHubAccessTokenRequest, clientRequestId, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientWorkspaceGitRepoManagements")
    public static interface WorkspaceGitRepoManagementsService {
        @Post(value="/getGitHubAccessToken")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<GitHubAccessTokenResponse>> getGitHubAccessToken(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") GitHubAccessTokenRequest var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

