/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.TriggerListResponse;
import com.azure.analytics.synapse.artifacts.models.TriggerResource;
import com.azure.analytics.synapse.artifacts.models.TriggerSubscriptionOperationStatus;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class TriggersImpl {
    private final TriggersService service;
    private final ArtifactsClientImpl client;

    TriggersImpl(ArtifactsClientImpl client) {
        this.service = (TriggersService)RestProxy.create(TriggersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<TriggerResource>> getTriggersByWorkspaceSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTriggersByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TriggerListResponse)res.getValue()).getValue(), ((TriggerListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<TriggerResource>> getTriggersByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getTriggersByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TriggerListResponse)res.getValue()).getValue(), ((TriggerListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TriggerResource> getTriggersByWorkspaceAsync() {
        return new PagedFlux(() -> this.getTriggersByWorkspaceSinglePageAsync(), nextLink -> this.getTriggersByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TriggerResource> getTriggersByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.getTriggersByWorkspaceSinglePageAsync(context), nextLink -> this.getTriggersByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<TriggerResource> getTriggersByWorkspaceSinglePage() {
        return (PagedResponse)this.getTriggersByWorkspaceSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<TriggerResource> getTriggersByWorkspaceSinglePage(Context context) {
        return (PagedResponse)this.getTriggersByWorkspaceSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TriggerResource> getTriggersByWorkspace() {
        return new PagedIterable(this.getTriggersByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TriggerResource> getTriggersByWorkspace(Context context) {
        return new PagedIterable(this.getTriggersByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerResource>> createOrUpdateTriggerWithResponseAsync(String triggerName, TriggerResource trigger, String ifMatch) {
        return FluxUtil.withContext(context -> this.createOrUpdateTriggerWithResponseAsync(triggerName, trigger, ifMatch, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerResource>> createOrUpdateTriggerWithResponseAsync(String triggerName, TriggerResource trigger, String ifMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.createOrUpdateTrigger(this.client.getEndpoint(), triggerName, "2020-12-01", ifMatch, trigger, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerResource> createOrUpdateTriggerAsync(String triggerName, TriggerResource trigger, String ifMatch) {
        return this.createOrUpdateTriggerWithResponseAsync(triggerName, trigger, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((TriggerResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerResource> createOrUpdateTriggerAsync(String triggerName, TriggerResource trigger) {
        String ifMatch = null;
        return this.createOrUpdateTriggerWithResponseAsync(triggerName, trigger, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((TriggerResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerResource> createOrUpdateTriggerAsync(String triggerName, TriggerResource trigger, String ifMatch, Context context) {
        return this.createOrUpdateTriggerWithResponseAsync(triggerName, trigger, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((TriggerResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerResource> createOrUpdateTriggerWithResponse(String triggerName, TriggerResource trigger, String ifMatch, Context context) {
        return (Response)this.createOrUpdateTriggerWithResponseAsync(triggerName, trigger, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerResource createOrUpdateTrigger(String triggerName, TriggerResource trigger, String ifMatch) {
        return (TriggerResource)this.createOrUpdateTriggerWithResponse(triggerName, trigger, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerResource createOrUpdateTrigger(String triggerName, TriggerResource trigger) {
        String ifMatch = null;
        return (TriggerResource)this.createOrUpdateTriggerWithResponse(triggerName, trigger, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerResource>> getTriggerWithResponseAsync(String triggerName, String ifNoneMatch) {
        return FluxUtil.withContext(context -> this.getTriggerWithResponseAsync(triggerName, ifNoneMatch, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerResource>> getTriggerWithResponseAsync(String triggerName, String ifNoneMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getTrigger(this.client.getEndpoint(), triggerName, "2020-12-01", ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerResource> getTriggerAsync(String triggerName, String ifNoneMatch) {
        return this.getTriggerWithResponseAsync(triggerName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((TriggerResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerResource> getTriggerAsync(String triggerName) {
        String ifNoneMatch = null;
        return this.getTriggerWithResponseAsync(triggerName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((TriggerResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerResource> getTriggerAsync(String triggerName, String ifNoneMatch, Context context) {
        return this.getTriggerWithResponseAsync(triggerName, ifNoneMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((TriggerResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerResource> getTriggerWithResponse(String triggerName, String ifNoneMatch, Context context) {
        return (Response)this.getTriggerWithResponseAsync(triggerName, ifNoneMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerResource getTrigger(String triggerName, String ifNoneMatch) {
        return (TriggerResource)this.getTriggerWithResponse(triggerName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerResource getTrigger(String triggerName) {
        String ifNoneMatch = null;
        return (TriggerResource)this.getTriggerWithResponse(triggerName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTriggerWithResponseAsync(String triggerName) {
        return FluxUtil.withContext(context -> this.deleteTriggerWithResponseAsync(triggerName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTriggerWithResponseAsync(String triggerName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.deleteTrigger(this.client.getEndpoint(), triggerName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTriggerAsync(String triggerName) {
        return this.deleteTriggerWithResponseAsync(triggerName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTriggerAsync(String triggerName, Context context) {
        return this.deleteTriggerWithResponseAsync(triggerName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTriggerWithResponse(String triggerName, Context context) {
        return (Response)this.deleteTriggerWithResponseAsync(triggerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTrigger(String triggerName) {
        this.deleteTriggerWithResponse(triggerName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerSubscriptionOperationStatus>> subscribeTriggerToEventsWithResponseAsync(String triggerName) {
        return FluxUtil.withContext(context -> this.subscribeTriggerToEventsWithResponseAsync(triggerName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerSubscriptionOperationStatus>> subscribeTriggerToEventsWithResponseAsync(String triggerName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.subscribeTriggerToEvents(this.client.getEndpoint(), triggerName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerSubscriptionOperationStatus> subscribeTriggerToEventsAsync(String triggerName) {
        return this.subscribeTriggerToEventsWithResponseAsync(triggerName).flatMap(res -> Mono.justOrEmpty((Object)((TriggerSubscriptionOperationStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerSubscriptionOperationStatus> subscribeTriggerToEventsAsync(String triggerName, Context context) {
        return this.subscribeTriggerToEventsWithResponseAsync(triggerName, context).flatMap(res -> Mono.justOrEmpty((Object)((TriggerSubscriptionOperationStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerSubscriptionOperationStatus> subscribeTriggerToEventsWithResponse(String triggerName, Context context) {
        return (Response)this.subscribeTriggerToEventsWithResponseAsync(triggerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerSubscriptionOperationStatus subscribeTriggerToEvents(String triggerName) {
        return (TriggerSubscriptionOperationStatus)this.subscribeTriggerToEventsWithResponse(triggerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerSubscriptionOperationStatus>> getEventSubscriptionStatusWithResponseAsync(String triggerName) {
        return FluxUtil.withContext(context -> this.getEventSubscriptionStatusWithResponseAsync(triggerName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerSubscriptionOperationStatus>> getEventSubscriptionStatusWithResponseAsync(String triggerName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getEventSubscriptionStatus(this.client.getEndpoint(), triggerName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerSubscriptionOperationStatus> getEventSubscriptionStatusAsync(String triggerName) {
        return this.getEventSubscriptionStatusWithResponseAsync(triggerName).flatMap(res -> Mono.justOrEmpty((Object)((TriggerSubscriptionOperationStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerSubscriptionOperationStatus> getEventSubscriptionStatusAsync(String triggerName, Context context) {
        return this.getEventSubscriptionStatusWithResponseAsync(triggerName, context).flatMap(res -> Mono.justOrEmpty((Object)((TriggerSubscriptionOperationStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerSubscriptionOperationStatus> getEventSubscriptionStatusWithResponse(String triggerName, Context context) {
        return (Response)this.getEventSubscriptionStatusWithResponseAsync(triggerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerSubscriptionOperationStatus getEventSubscriptionStatus(String triggerName) {
        return (TriggerSubscriptionOperationStatus)this.getEventSubscriptionStatusWithResponse(triggerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerSubscriptionOperationStatus>> unsubscribeTriggerFromEventsWithResponseAsync(String triggerName) {
        return FluxUtil.withContext(context -> this.unsubscribeTriggerFromEventsWithResponseAsync(triggerName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerSubscriptionOperationStatus>> unsubscribeTriggerFromEventsWithResponseAsync(String triggerName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.unsubscribeTriggerFromEvents(this.client.getEndpoint(), triggerName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerSubscriptionOperationStatus> unsubscribeTriggerFromEventsAsync(String triggerName) {
        return this.unsubscribeTriggerFromEventsWithResponseAsync(triggerName).flatMap(res -> Mono.justOrEmpty((Object)((TriggerSubscriptionOperationStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerSubscriptionOperationStatus> unsubscribeTriggerFromEventsAsync(String triggerName, Context context) {
        return this.unsubscribeTriggerFromEventsWithResponseAsync(triggerName, context).flatMap(res -> Mono.justOrEmpty((Object)((TriggerSubscriptionOperationStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerSubscriptionOperationStatus> unsubscribeTriggerFromEventsWithResponse(String triggerName, Context context) {
        return (Response)this.unsubscribeTriggerFromEventsWithResponseAsync(triggerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerSubscriptionOperationStatus unsubscribeTriggerFromEvents(String triggerName) {
        return (TriggerSubscriptionOperationStatus)this.unsubscribeTriggerFromEventsWithResponse(triggerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startTriggerWithResponseAsync(String triggerName) {
        return FluxUtil.withContext(context -> this.startTriggerWithResponseAsync(triggerName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startTriggerWithResponseAsync(String triggerName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.startTrigger(this.client.getEndpoint(), triggerName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startTriggerAsync(String triggerName) {
        return this.startTriggerWithResponseAsync(triggerName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startTriggerAsync(String triggerName, Context context) {
        return this.startTriggerWithResponseAsync(triggerName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startTriggerWithResponse(String triggerName, Context context) {
        return (Response)this.startTriggerWithResponseAsync(triggerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startTrigger(String triggerName) {
        this.startTriggerWithResponse(triggerName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopTriggerWithResponseAsync(String triggerName) {
        return FluxUtil.withContext(context -> this.stopTriggerWithResponseAsync(triggerName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopTriggerWithResponseAsync(String triggerName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.stopTrigger(this.client.getEndpoint(), triggerName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopTriggerAsync(String triggerName) {
        return this.stopTriggerWithResponseAsync(triggerName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopTriggerAsync(String triggerName, Context context) {
        return this.stopTriggerWithResponseAsync(triggerName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopTriggerWithResponse(String triggerName, Context context) {
        return (Response)this.stopTriggerWithResponseAsync(triggerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopTrigger(String triggerName) {
        this.stopTriggerWithResponse(triggerName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<TriggerResource>> getTriggersByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTriggersByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TriggerListResponse)res.getValue()).getValue(), ((TriggerListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<TriggerResource>> getTriggersByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getTriggersByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TriggerListResponse)res.getValue()).getValue(), ((TriggerListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<TriggerResource> getTriggersByWorkspaceNextSinglePage(String nextLink) {
        return (PagedResponse)this.getTriggersByWorkspaceNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<TriggerResource> getTriggersByWorkspaceNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.getTriggersByWorkspaceNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientTriggers")
    public static interface TriggersService {
        @Get(value="/triggers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<TriggerListResponse>> getTriggersByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Put(value="/triggers/{triggerName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<TriggerResource>> createOrUpdateTrigger(@HostParam(value="endpoint") String var1, @PathParam(value="triggerName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/json") TriggerResource var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/triggers/{triggerName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<TriggerResource>> getTrigger(@HostParam(value="endpoint") String var1, @PathParam(value="triggerName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-None-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/triggers/{triggerName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> deleteTrigger(@HostParam(value="endpoint") String var1, @PathParam(value="triggerName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/triggers/{triggerName}/subscribeToEvents")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<TriggerSubscriptionOperationStatus>> subscribeTriggerToEvents(@HostParam(value="endpoint") String var1, @PathParam(value="triggerName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/triggers/{triggerName}/getEventSubscriptionStatus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<TriggerSubscriptionOperationStatus>> getEventSubscriptionStatus(@HostParam(value="endpoint") String var1, @PathParam(value="triggerName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/triggers/{triggerName}/unsubscribeFromEvents")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<TriggerSubscriptionOperationStatus>> unsubscribeTriggerFromEvents(@HostParam(value="endpoint") String var1, @PathParam(value="triggerName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/triggers/{triggerName}/start")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> startTrigger(@HostParam(value="endpoint") String var1, @PathParam(value="triggerName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/triggers/{triggerName}/stop")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> stopTrigger(@HostParam(value="endpoint") String var1, @PathParam(value="triggerName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<TriggerListResponse>> getTriggersByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

