/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ErrorContractException;
import com.azure.analytics.synapse.artifacts.models.MetastoreRegisterObject;
import com.azure.analytics.synapse.artifacts.models.MetastoreRegistrationResponse;
import com.azure.analytics.synapse.artifacts.models.MetastoreRequestSuccessResponse;
import com.azure.analytics.synapse.artifacts.models.MetastoreUpdateObject;
import com.azure.analytics.synapse.artifacts.models.MetastoreUpdationResponse;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class MetastoresImpl {
    private final MetastoresService service;
    private final ArtifactsClientImpl client;

    MetastoresImpl(ArtifactsClientImpl client) {
        this.service = (MetastoresService)RestProxy.create(MetastoresService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetastoreRegistrationResponse>> registerWithResponseAsync(String id, MetastoreRegisterObject registerBody) {
        return FluxUtil.withContext(context -> this.registerWithResponseAsync(id, registerBody, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetastoreRegistrationResponse>> registerWithResponseAsync(String id, MetastoreRegisterObject registerBody, Context context) {
        String apiVersion = "2021-07-01-preview";
        String accept = "application/json";
        return this.service.register(this.client.getEndpoint(), "2021-07-01-preview", id, registerBody, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetastoreRegistrationResponse> registerAsync(String id, MetastoreRegisterObject registerBody) {
        return this.registerWithResponseAsync(id, registerBody).flatMap(res -> Mono.justOrEmpty((Object)((MetastoreRegistrationResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetastoreRegistrationResponse> registerAsync(String id, MetastoreRegisterObject registerBody, Context context) {
        return this.registerWithResponseAsync(id, registerBody, context).flatMap(res -> Mono.justOrEmpty((Object)((MetastoreRegistrationResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetastoreRegistrationResponse> registerWithResponse(String id, MetastoreRegisterObject registerBody, Context context) {
        return (Response)this.registerWithResponseAsync(id, registerBody, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetastoreRegistrationResponse register(String id, MetastoreRegisterObject registerBody) {
        return (MetastoreRegistrationResponse)this.registerWithResponse(id, registerBody, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetastoreRequestSuccessResponse>> getDatabaseOperationsWithResponseAsync(String id) {
        return FluxUtil.withContext(context -> this.getDatabaseOperationsWithResponseAsync(id, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetastoreRequestSuccessResponse>> getDatabaseOperationsWithResponseAsync(String id, Context context) {
        String apiVersion = "2021-07-01-preview";
        String accept = "application/json";
        return this.service.getDatabaseOperations(this.client.getEndpoint(), "2021-07-01-preview", id, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetastoreRequestSuccessResponse> getDatabaseOperationsAsync(String id) {
        return this.getDatabaseOperationsWithResponseAsync(id).flatMap(res -> Mono.justOrEmpty((Object)((MetastoreRequestSuccessResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetastoreRequestSuccessResponse> getDatabaseOperationsAsync(String id, Context context) {
        return this.getDatabaseOperationsWithResponseAsync(id, context).flatMap(res -> Mono.justOrEmpty((Object)((MetastoreRequestSuccessResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetastoreRequestSuccessResponse> getDatabaseOperationsWithResponse(String id, Context context) {
        return (Response)this.getDatabaseOperationsWithResponseAsync(id, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetastoreRequestSuccessResponse getDatabaseOperations(String id) {
        return (MetastoreRequestSuccessResponse)this.getDatabaseOperationsWithResponse(id, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetastoreUpdationResponse>> updateWithResponseAsync(String id, MetastoreUpdateObject updateBody) {
        return FluxUtil.withContext(context -> this.updateWithResponseAsync(id, updateBody, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetastoreUpdationResponse>> updateWithResponseAsync(String id, MetastoreUpdateObject updateBody, Context context) {
        String apiVersion = "2021-07-01-preview";
        String accept = "application/json";
        return this.service.update(this.client.getEndpoint(), "2021-07-01-preview", id, updateBody, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetastoreUpdationResponse> updateAsync(String id, MetastoreUpdateObject updateBody) {
        return this.updateWithResponseAsync(id, updateBody).flatMap(res -> Mono.justOrEmpty((Object)((MetastoreUpdationResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetastoreUpdationResponse> updateAsync(String id, MetastoreUpdateObject updateBody, Context context) {
        return this.updateWithResponseAsync(id, updateBody, context).flatMap(res -> Mono.justOrEmpty((Object)((MetastoreUpdationResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MetastoreUpdationResponse> updateWithResponse(String id, MetastoreUpdateObject updateBody, Context context) {
        return (Response)this.updateWithResponseAsync(id, updateBody, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetastoreUpdationResponse update(String id, MetastoreUpdateObject updateBody) {
        return (MetastoreUpdationResponse)this.updateWithResponse(id, updateBody, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String id) {
        return FluxUtil.withContext(context -> this.deleteWithResponseAsync(id, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String id, Context context) {
        String apiVersion = "2021-07-01-preview";
        String accept = "application/json";
        return this.service.delete(this.client.getEndpoint(), "2021-07-01-preview", id, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String id) {
        return this.deleteWithResponseAsync(id).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String id, Context context) {
        return this.deleteWithResponseAsync(id, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String id, Context context) {
        return (Response)this.deleteWithResponseAsync(id, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String id) {
        this.deleteWithResponse(id, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientMetastores")
    public static interface MetastoresService {
        @Put(value="/metastore/create-database-operations/{id}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<MetastoreRegistrationResponse>> register(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="id") String var3, @BodyParam(value="application/json") MetastoreRegisterObject var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/metastore/create-database-operations/{id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<MetastoreRequestSuccessResponse>> getDatabaseOperations(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="id") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/metastore/update-database-operations/{id}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<MetastoreUpdationResponse>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="id") String var3, @BodyParam(value="application/json") MetastoreUpdateObject var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/metastore/databases/{id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="id") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

