/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.TriggerRunsImpl;
import com.azure.analytics.synapse.artifacts.models.RunFilterParameters;
import com.azure.analytics.synapse.artifacts.models.TriggerRunsQueryResponse;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class TriggerRunAsyncClient {
    private final TriggerRunsImpl serviceClient;

    TriggerRunAsyncClient(TriggerRunsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rerunTriggerInstanceWithResponse(String triggerName, String runId) {
        return this.serviceClient.rerunTriggerInstanceWithResponseAsync(triggerName, runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rerunTriggerInstance(String triggerName, String runId) {
        return this.serviceClient.rerunTriggerInstanceAsync(triggerName, runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelTriggerInstanceWithResponse(String triggerName, String runId) {
        return this.serviceClient.cancelTriggerInstanceWithResponseAsync(triggerName, runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelTriggerInstance(String triggerName, String runId) {
        return this.serviceClient.cancelTriggerInstanceAsync(triggerName, runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerRunsQueryResponse>> queryTriggerRunsByWorkspaceWithResponse(RunFilterParameters filterParameters) {
        return this.serviceClient.queryTriggerRunsByWorkspaceWithResponseAsync(filterParameters);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerRunsQueryResponse> queryTriggerRunsByWorkspace(RunFilterParameters filterParameters) {
        return this.serviceClient.queryTriggerRunsByWorkspaceAsync(filterParameters);
    }
}

