/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.SqlPoolsImpl;
import com.azure.analytics.synapse.artifacts.models.SqlPool;
import com.azure.analytics.synapse.artifacts.models.SqlPoolInfoListResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class SqlPoolsAsyncClient {
    private final SqlPoolsImpl serviceClient;

    SqlPoolsAsyncClient(SqlPoolsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlPoolInfoListResult>> listWithResponse() {
        return this.serviceClient.listWithResponseAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlPoolInfoListResult> list() {
        return this.serviceClient.listAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlPool>> getWithResponse(String sqlPoolName) {
        return this.serviceClient.getWithResponseAsync(sqlPoolName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlPool> get(String sqlPoolName) {
        return this.serviceClient.getAsync(sqlPoolName);
    }
}

