/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.SparkJobDefinitionsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.SparkBatchJob;
import com.azure.analytics.synapse.artifacts.models.SparkJobDefinitionResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class SparkJobDefinitionAsyncClient {
    private final SparkJobDefinitionsImpl serviceClient;

    SparkJobDefinitionAsyncClient(SparkJobDefinitionsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspace() {
        return this.serviceClient.getSparkJobDefinitionsByWorkspaceAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkJobDefinitionResource>> createOrUpdateSparkJobDefinitionWithResponse(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition, String ifMatch) {
        return this.serviceClient.createOrUpdateSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, sparkJobDefinition, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkJobDefinitionResource> createOrUpdateSparkJobDefinition(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition, String ifMatch) {
        return this.serviceClient.createOrUpdateSparkJobDefinitionAsync(sparkJobDefinitionName, sparkJobDefinition, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkJobDefinitionResource> createOrUpdateSparkJobDefinition(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition) {
        return this.serviceClient.createOrUpdateSparkJobDefinitionAsync(sparkJobDefinitionName, sparkJobDefinition);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkJobDefinitionResource>> getSparkJobDefinitionWithResponse(String sparkJobDefinitionName, String ifNoneMatch) {
        return this.serviceClient.getSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkJobDefinitionResource> getSparkJobDefinition(String sparkJobDefinitionName, String ifNoneMatch) {
        return this.serviceClient.getSparkJobDefinitionAsync(sparkJobDefinitionName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkJobDefinitionResource> getSparkJobDefinition(String sparkJobDefinitionName) {
        return this.serviceClient.getSparkJobDefinitionAsync(sparkJobDefinitionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSparkJobDefinitionWithResponse(String sparkJobDefinitionName) {
        return this.serviceClient.deleteSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSparkJobDefinition(String sparkJobDefinitionName) {
        return this.serviceClient.deleteSparkJobDefinitionAsync(sparkJobDefinitionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> executeSparkJobDefinitionWithResponse(String sparkJobDefinitionName) {
        return this.serviceClient.executeSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> executeSparkJobDefinition(String sparkJobDefinitionName) {
        return this.serviceClient.executeSparkJobDefinitionAsync(sparkJobDefinitionName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameSparkJobDefinitionWithResponse(String sparkJobDefinitionName, ArtifactRenameRequest request) {
        return this.serviceClient.renameSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameSparkJobDefinition(String sparkJobDefinitionName, ArtifactRenameRequest request) {
        return this.serviceClient.renameSparkJobDefinitionAsync(sparkJobDefinitionName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> debugSparkJobDefinitionWithResponse(SparkJobDefinitionResource sparkJobDefinitionAzureResource) {
        return this.serviceClient.debugSparkJobDefinitionWithResponseAsync(sparkJobDefinitionAzureResource);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> debugSparkJobDefinition(SparkJobDefinitionResource sparkJobDefinitionAzureResource) {
        return this.serviceClient.debugSparkJobDefinitionAsync(sparkJobDefinitionAzureResource);
    }
}

