/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.PipelineRunsImpl;
import com.azure.analytics.synapse.artifacts.models.ActivityRunsQueryResponse;
import com.azure.analytics.synapse.artifacts.models.PipelineRun;
import com.azure.analytics.synapse.artifacts.models.PipelineRunsQueryResponse;
import com.azure.analytics.synapse.artifacts.models.RunFilterParameters;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class PipelineRunClient {
    private final PipelineRunsImpl serviceClient;

    PipelineRunClient(PipelineRunsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PipelineRunsQueryResponse> queryPipelineRunsByWorkspaceWithResponse(RunFilterParameters filterParameters, Context context) {
        return this.serviceClient.queryPipelineRunsByWorkspaceWithResponse(filterParameters, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineRunsQueryResponse queryPipelineRunsByWorkspace(RunFilterParameters filterParameters) {
        return this.serviceClient.queryPipelineRunsByWorkspace(filterParameters);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PipelineRun> getPipelineRunWithResponse(String runId, Context context) {
        return this.serviceClient.getPipelineRunWithResponse(runId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineRun getPipelineRun(String runId) {
        return this.serviceClient.getPipelineRun(runId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ActivityRunsQueryResponse> queryActivityRunsWithResponse(String pipelineName, String runId, RunFilterParameters filterParameters, Context context) {
        return this.serviceClient.queryActivityRunsWithResponse(pipelineName, runId, filterParameters, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ActivityRunsQueryResponse queryActivityRuns(String pipelineName, String runId, RunFilterParameters filterParameters) {
        return this.serviceClient.queryActivityRuns(pipelineName, runId, filterParameters);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelPipelineRunWithResponse(String runId, Boolean isRecursive, Context context) {
        return this.serviceClient.cancelPipelineRunWithResponse(runId, isRecursive, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelPipelineRun(String runId, Boolean isRecursive) {
        this.serviceClient.cancelPipelineRun(runId, isRecursive);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelPipelineRun(String runId) {
        this.serviceClient.cancelPipelineRun(runId);
    }
}

