/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.PipelinesImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.CreateRunResponse;
import com.azure.analytics.synapse.artifacts.models.PipelineResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import java.util.Map;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class PipelineAsyncClient {
    private final PipelinesImpl serviceClient;

    PipelineAsyncClient(PipelinesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PipelineResource> getPipelinesByWorkspace() {
        return this.serviceClient.getPipelinesByWorkspaceAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineResource>> createOrUpdatePipelineWithResponse(String pipelineName, PipelineResource pipeline, String ifMatch) {
        return this.serviceClient.createOrUpdatePipelineWithResponseAsync(pipelineName, pipeline, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineResource> createOrUpdatePipeline(String pipelineName, PipelineResource pipeline, String ifMatch) {
        return this.serviceClient.createOrUpdatePipelineAsync(pipelineName, pipeline, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineResource> createOrUpdatePipeline(String pipelineName, PipelineResource pipeline) {
        return this.serviceClient.createOrUpdatePipelineAsync(pipelineName, pipeline);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineResource>> getPipelineWithResponse(String pipelineName, String ifNoneMatch) {
        return this.serviceClient.getPipelineWithResponseAsync(pipelineName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineResource> getPipeline(String pipelineName, String ifNoneMatch) {
        return this.serviceClient.getPipelineAsync(pipelineName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineResource> getPipeline(String pipelineName) {
        return this.serviceClient.getPipelineAsync(pipelineName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deletePipelineWithResponse(String pipelineName) {
        return this.serviceClient.deletePipelineWithResponseAsync(pipelineName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePipeline(String pipelineName) {
        return this.serviceClient.deletePipelineAsync(pipelineName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renamePipelineWithResponse(String pipelineName, ArtifactRenameRequest request) {
        return this.serviceClient.renamePipelineWithResponseAsync(pipelineName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renamePipeline(String pipelineName, ArtifactRenameRequest request) {
        return this.serviceClient.renamePipelineAsync(pipelineName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateRunResponse>> createPipelineRunWithResponse(String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Map<String, Object> parameters) {
        return this.serviceClient.createPipelineRunWithResponseAsync(pipelineName, referencePipelineRunId, isRecovery, startActivityName, parameters);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateRunResponse> createPipelineRun(String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Map<String, Object> parameters) {
        return this.serviceClient.createPipelineRunAsync(pipelineName, referencePipelineRunId, isRecovery, startActivityName, parameters);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateRunResponse> createPipelineRun(String pipelineName) {
        return this.serviceClient.createPipelineRunAsync(pipelineName);
    }
}

