/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.NotebooksImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.NotebookResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class NotebookAsyncClient {
    private final NotebooksImpl serviceClient;

    NotebookAsyncClient(NotebooksImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NotebookResource> getNotebooksByWorkspace() {
        return this.serviceClient.getNotebooksByWorkspaceAsync();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NotebookResource> getNotebookSummaryByWorkSpace() {
        return this.serviceClient.getNotebookSummaryByWorkSpaceAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NotebookResource>> createOrUpdateNotebookWithResponse(String notebookName, NotebookResource notebook, String ifMatch) {
        return this.serviceClient.createOrUpdateNotebookWithResponseAsync(notebookName, notebook, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotebookResource> createOrUpdateNotebook(String notebookName, NotebookResource notebook, String ifMatch) {
        return this.serviceClient.createOrUpdateNotebookAsync(notebookName, notebook, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotebookResource> createOrUpdateNotebook(String notebookName, NotebookResource notebook) {
        return this.serviceClient.createOrUpdateNotebookAsync(notebookName, notebook);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NotebookResource>> getNotebookWithResponse(String notebookName, String ifNoneMatch) {
        return this.serviceClient.getNotebookWithResponseAsync(notebookName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotebookResource> getNotebook(String notebookName, String ifNoneMatch) {
        return this.serviceClient.getNotebookAsync(notebookName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotebookResource> getNotebook(String notebookName) {
        return this.serviceClient.getNotebookAsync(notebookName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNotebookWithResponse(String notebookName) {
        return this.serviceClient.deleteNotebookWithResponseAsync(notebookName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNotebook(String notebookName) {
        return this.serviceClient.deleteNotebookAsync(notebookName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameNotebookWithResponse(String notebookName, ArtifactRenameRequest request) {
        return this.serviceClient.renameNotebookWithResponseAsync(notebookName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameNotebook(String notebookName, ArtifactRenameRequest request) {
        return this.serviceClient.renameNotebookAsync(notebookName, request);
    }
}

