/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.MetastoresImpl;
import com.azure.analytics.synapse.artifacts.models.MetastoreRegisterObject;
import com.azure.analytics.synapse.artifacts.models.MetastoreRegistrationResponse;
import com.azure.analytics.synapse.artifacts.models.MetastoreRequestSuccessResponse;
import com.azure.analytics.synapse.artifacts.models.MetastoreUpdateObject;
import com.azure.analytics.synapse.artifacts.models.MetastoreUpdationResponse;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class MetastoreAsyncClient {
    private final MetastoresImpl serviceClient;

    MetastoreAsyncClient(MetastoresImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetastoreRegistrationResponse>> registerWithResponse(String id, MetastoreRegisterObject registerBody) {
        return this.serviceClient.registerWithResponseAsync(id, registerBody);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetastoreRegistrationResponse> register(String id, MetastoreRegisterObject registerBody) {
        return this.serviceClient.registerAsync(id, registerBody);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetastoreRequestSuccessResponse>> getDatabaseOperationsWithResponse(String id) {
        return this.serviceClient.getDatabaseOperationsWithResponseAsync(id);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetastoreRequestSuccessResponse> getDatabaseOperations(String id) {
        return this.serviceClient.getDatabaseOperationsAsync(id);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MetastoreUpdationResponse>> updateWithResponse(String id, MetastoreUpdateObject updateBody) {
        return this.serviceClient.updateWithResponseAsync(id, updateBody);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetastoreUpdationResponse> update(String id, MetastoreUpdateObject updateBody) {
        return this.serviceClient.updateAsync(id, updateBody);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(String id) {
        return this.serviceClient.deleteWithResponseAsync(id);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete(String id) {
        return this.serviceClient.deleteAsync(id);
    }
}

