/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.LibrariesImpl;
import com.azure.analytics.synapse.artifacts.models.LibraryResource;
import com.azure.analytics.synapse.artifacts.models.LibraryResourceInfo;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class LibraryClient {
    private final LibrariesImpl serviceClient;

    LibraryClient(LibrariesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LibraryResource> list() {
        return this.serviceClient.list();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LibraryResource> list(Context context) {
        return this.serviceClient.list(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LibraryResourceInfo> flushWithResponse(String libraryName, Context context) {
        return this.serviceClient.flushWithResponse(libraryName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LibraryResourceInfo flush(String libraryName) {
        return this.serviceClient.flush(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LibraryResource> getOperationResultWithResponse(String operationId, Context context) {
        return this.serviceClient.getOperationResultWithResponse(operationId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LibraryResource getOperationResult(String operationId) {
        return this.serviceClient.getOperationResult(operationId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LibraryResourceInfo> deleteWithResponse(String libraryName, Context context) {
        return this.serviceClient.deleteWithResponse(libraryName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LibraryResourceInfo delete(String libraryName) {
        return this.serviceClient.delete(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LibraryResource> getWithResponse(String libraryName, Context context) {
        return this.serviceClient.getWithResponse(libraryName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LibraryResource get(String libraryName) {
        return this.serviceClient.get(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LibraryResourceInfo> createWithResponse(String libraryName, Context context) {
        return this.serviceClient.createWithResponse(libraryName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LibraryResourceInfo create(String libraryName) {
        return this.serviceClient.create(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(String libraryName, Flux<ByteBuffer> content, long contentLength, Long blobConditionAppendPosition, Context context) {
        return this.serviceClient.appendWithResponse(libraryName, content, contentLength, blobConditionAppendPosition, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void append(String libraryName, Flux<ByteBuffer> content, long contentLength, Long blobConditionAppendPosition) {
        this.serviceClient.append(libraryName, content, contentLength, blobConditionAppendPosition);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void append(String libraryName, Flux<ByteBuffer> content, long contentLength) {
        this.serviceClient.append(libraryName, content, contentLength);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(String libraryName, BinaryData content, long contentLength, Long blobConditionAppendPosition, Context context) {
        return this.serviceClient.appendWithResponse(libraryName, content, contentLength, blobConditionAppendPosition, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void append(String libraryName, BinaryData content, long contentLength, Long blobConditionAppendPosition) {
        this.serviceClient.append(libraryName, content, contentLength, blobConditionAppendPosition);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void append(String libraryName, BinaryData content, long contentLength) {
        this.serviceClient.append(libraryName, content, contentLength);
    }
}

