/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.BigDataPoolsImpl;
import com.azure.analytics.synapse.artifacts.models.BigDataPoolResourceInfo;
import com.azure.analytics.synapse.artifacts.models.BigDataPoolResourceInfoListResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class BigDataPoolsAsyncClient {
    private final BigDataPoolsImpl serviceClient;

    BigDataPoolsAsyncClient(BigDataPoolsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BigDataPoolResourceInfoListResult>> listWithResponse() {
        return this.serviceClient.listWithResponseAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BigDataPoolResourceInfoListResult> list() {
        return this.serviceClient.listAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BigDataPoolResourceInfo>> getWithResponse(String bigDataPoolName) {
        return this.serviceClient.getWithResponseAsync(bigDataPoolName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BigDataPoolResourceInfo> get(String bigDataPoolName) {
        return this.serviceClient.getAsync(bigDataPoolName);
    }
}

