/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.ImportStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImportInfo
implements JsonSerializable<ImportInfo> {
    private String childObjectName;
    private ImportStatus importStatus;
    private String parentObjectName;
    private String remarks;

    private ImportInfo() {
    }

    public String getChildObjectName() {
        return this.childObjectName;
    }

    public ImportStatus getImportStatus() {
        return this.importStatus;
    }

    public String getParentObjectName() {
        return this.parentObjectName;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("childObjectName", this.childObjectName);
        jsonWriter.writeStringField("importStatus", this.importStatus == null ? null : this.importStatus.toString());
        jsonWriter.writeStringField("parentObjectName", this.parentObjectName);
        jsonWriter.writeStringField("remarks", this.remarks);
        return jsonWriter.writeEndObject();
    }

    public static ImportInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ImportInfo)jsonReader.readObject(reader -> {
            ImportInfo deserializedImportInfo = new ImportInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("childObjectName".equals(fieldName)) {
                    deserializedImportInfo.childObjectName = reader.getString();
                    continue;
                }
                if ("importStatus".equals(fieldName)) {
                    deserializedImportInfo.importStatus = ImportStatus.fromString(reader.getString());
                    continue;
                }
                if ("parentObjectName".equals(fieldName)) {
                    deserializedImportInfo.parentObjectName = reader.getString();
                    continue;
                }
                if ("remarks".equals(fieldName)) {
                    deserializedImportInfo.remarks = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportInfo;
        });
    }
}

