/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.AtlasEntityHeader;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class EntityMutationResult
implements JsonSerializable<EntityMutationResult> {
    private Map<String, String> guidAssignments;
    private Map<String, List<AtlasEntityHeader>> mutatedEntities;
    private List<AtlasEntityHeader> partialUpdatedEntities;

    private EntityMutationResult() {
    }

    public Map<String, String> getGuidAssignments() {
        return this.guidAssignments;
    }

    public Map<String, List<AtlasEntityHeader>> getMutatedEntities() {
        return this.mutatedEntities;
    }

    public List<AtlasEntityHeader> getPartialUpdatedEntities() {
        return this.partialUpdatedEntities;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("guidAssignments", this.guidAssignments, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("mutatedEntities", this.mutatedEntities, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
        jsonWriter.writeArrayField("partialUpdatedEntities", this.partialUpdatedEntities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EntityMutationResult fromJson(JsonReader jsonReader) throws IOException {
        return (EntityMutationResult)jsonReader.readObject(reader -> {
            EntityMutationResult deserializedEntityMutationResult = new EntityMutationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("guidAssignments".equals(fieldName)) {
                    Map guidAssignments;
                    deserializedEntityMutationResult.guidAssignments = guidAssignments = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("mutatedEntities".equals(fieldName)) {
                    Map mutatedEntities;
                    deserializedEntityMutationResult.mutatedEntities = mutatedEntities = reader.readMap(reader1 -> reader1.readArray(reader2 -> AtlasEntityHeader.fromJson(reader2)));
                    continue;
                }
                if ("partialUpdatedEntities".equals(fieldName)) {
                    List partialUpdatedEntities;
                    deserializedEntityMutationResult.partialUpdatedEntities = partialUpdatedEntities = reader.readArray(reader1 -> AtlasEntityHeader.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntityMutationResult;
        });
    }
}

