/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.AtlasStruct;
import com.azure.analytics.purview.datamap.models.EntityStatus;
import com.azure.analytics.purview.datamap.models.StatusAtlasRelationship;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class AtlasRelatedObjectId
implements JsonSerializable<AtlasRelatedObjectId> {
    private String guid;
    private String typeName;
    private Map<String, BinaryData> uniqueAttributes;
    private String displayText;
    private EntityStatus entityStatus;
    private String relationshipType;
    private AtlasStruct relationshipAttributes;
    private String relationshipGuid;
    private StatusAtlasRelationship relationshipStatus;

    public String getGuid() {
        return this.guid;
    }

    public AtlasRelatedObjectId setGuid(String guid) {
        this.guid = guid;
        return this;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public AtlasRelatedObjectId setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public Map<String, BinaryData> getUniqueAttributes() {
        return this.uniqueAttributes;
    }

    public AtlasRelatedObjectId setUniqueAttributes(Map<String, BinaryData> uniqueAttributes) {
        this.uniqueAttributes = uniqueAttributes;
        return this;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public AtlasRelatedObjectId setDisplayText(String displayText) {
        this.displayText = displayText;
        return this;
    }

    public EntityStatus getEntityStatus() {
        return this.entityStatus;
    }

    public AtlasRelatedObjectId setEntityStatus(EntityStatus entityStatus) {
        this.entityStatus = entityStatus;
        return this;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public AtlasRelatedObjectId setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    public AtlasStruct getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    public AtlasRelatedObjectId setRelationshipAttributes(AtlasStruct relationshipAttributes) {
        this.relationshipAttributes = relationshipAttributes;
        return this;
    }

    public String getRelationshipGuid() {
        return this.relationshipGuid;
    }

    public AtlasRelatedObjectId setRelationshipGuid(String relationshipGuid) {
        this.relationshipGuid = relationshipGuid;
        return this;
    }

    public StatusAtlasRelationship getRelationshipStatus() {
        return this.relationshipStatus;
    }

    public AtlasRelatedObjectId setRelationshipStatus(StatusAtlasRelationship relationshipStatus) {
        this.relationshipStatus = relationshipStatus;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("guid", this.guid);
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeMapField("uniqueAttributes", this.uniqueAttributes, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("displayText", this.displayText);
        jsonWriter.writeStringField("entityStatus", this.entityStatus == null ? null : this.entityStatus.toString());
        jsonWriter.writeStringField("relationshipType", this.relationshipType);
        jsonWriter.writeJsonField("relationshipAttributes", (JsonSerializable)this.relationshipAttributes);
        jsonWriter.writeStringField("relationshipGuid", this.relationshipGuid);
        jsonWriter.writeStringField("relationshipStatus", this.relationshipStatus == null ? null : this.relationshipStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static AtlasRelatedObjectId fromJson(JsonReader jsonReader) throws IOException {
        return (AtlasRelatedObjectId)jsonReader.readObject(reader -> {
            AtlasRelatedObjectId deserializedAtlasRelatedObjectId = new AtlasRelatedObjectId();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("guid".equals(fieldName)) {
                    deserializedAtlasRelatedObjectId.guid = reader.getString();
                    continue;
                }
                if ("typeName".equals(fieldName)) {
                    deserializedAtlasRelatedObjectId.typeName = reader.getString();
                    continue;
                }
                if ("uniqueAttributes".equals(fieldName)) {
                    Map uniqueAttributes;
                    deserializedAtlasRelatedObjectId.uniqueAttributes = uniqueAttributes = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("displayText".equals(fieldName)) {
                    deserializedAtlasRelatedObjectId.displayText = reader.getString();
                    continue;
                }
                if ("entityStatus".equals(fieldName)) {
                    deserializedAtlasRelatedObjectId.entityStatus = EntityStatus.fromString(reader.getString());
                    continue;
                }
                if ("relationshipType".equals(fieldName)) {
                    deserializedAtlasRelatedObjectId.relationshipType = reader.getString();
                    continue;
                }
                if ("relationshipAttributes".equals(fieldName)) {
                    deserializedAtlasRelatedObjectId.relationshipAttributes = AtlasStruct.fromJson(reader);
                    continue;
                }
                if ("relationshipGuid".equals(fieldName)) {
                    deserializedAtlasRelatedObjectId.relationshipGuid = reader.getString();
                    continue;
                }
                if ("relationshipStatus".equals(fieldName)) {
                    deserializedAtlasRelatedObjectId.relationshipStatus = StatusAtlasRelationship.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAtlasRelatedObjectId;
        });
    }
}

