/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.AtlasClassification;
import com.azure.analytics.purview.datamap.models.AtlasGlossaryCategory;
import com.azure.analytics.purview.datamap.models.AtlasGlossaryTerm;
import com.azure.analytics.purview.datamap.models.AtlasRelatedCategoryHeader;
import com.azure.analytics.purview.datamap.models.AtlasRelatedTermHeader;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AtlasGlossaryExtInfo
implements JsonSerializable<AtlasGlossaryExtInfo> {
    private String guid;
    private List<AtlasClassification> classifications;
    private String longDescription;
    private String name;
    private String qualifiedName;
    private String shortDescription;
    private String lastModifiedTS;
    private Long createTime;
    private String createdBy;
    private Long updateTime;
    private String updatedBy;
    private List<AtlasRelatedCategoryHeader> categories;
    private String language;
    private List<AtlasRelatedTermHeader> terms;
    private String usage;
    private Map<String, AtlasGlossaryCategory> categoryInfo;
    private Map<String, AtlasGlossaryTerm> termInfo;

    private AtlasGlossaryExtInfo() {
    }

    public String getGuid() {
        return this.guid;
    }

    public List<AtlasClassification> getClassifications() {
        return this.classifications;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLastModifiedTS() {
        return this.lastModifiedTS;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public List<AtlasRelatedCategoryHeader> getCategories() {
        return this.categories;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<AtlasRelatedTermHeader> getTerms() {
        return this.terms;
    }

    public String getUsage() {
        return this.usage;
    }

    public Map<String, AtlasGlossaryCategory> getCategoryInfo() {
        return this.categoryInfo;
    }

    public Map<String, AtlasGlossaryTerm> getTermInfo() {
        return this.termInfo;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("guid", this.guid);
        jsonWriter.writeArrayField("classifications", this.classifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("longDescription", this.longDescription);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("qualifiedName", this.qualifiedName);
        jsonWriter.writeStringField("shortDescription", this.shortDescription);
        jsonWriter.writeStringField("lastModifiedTS", this.lastModifiedTS);
        jsonWriter.writeNumberField("createTime", (Number)this.createTime);
        jsonWriter.writeStringField("createdBy", this.createdBy);
        jsonWriter.writeNumberField("updateTime", (Number)this.updateTime);
        jsonWriter.writeStringField("updatedBy", this.updatedBy);
        jsonWriter.writeArrayField("categories", this.categories, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeArrayField("terms", this.terms, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("usage", this.usage);
        jsonWriter.writeMapField("categoryInfo", this.categoryInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("termInfo", this.termInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AtlasGlossaryExtInfo fromJson(JsonReader jsonReader) throws IOException {
        return (AtlasGlossaryExtInfo)jsonReader.readObject(reader -> {
            AtlasGlossaryExtInfo deserializedAtlasGlossaryExtInfo = new AtlasGlossaryExtInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("guid".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.guid = reader.getString();
                    continue;
                }
                if ("classifications".equals(fieldName)) {
                    List classifications;
                    deserializedAtlasGlossaryExtInfo.classifications = classifications = reader.readArray(reader1 -> AtlasClassification.fromJson(reader1));
                    continue;
                }
                if ("longDescription".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.longDescription = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.name = reader.getString();
                    continue;
                }
                if ("qualifiedName".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.qualifiedName = reader.getString();
                    continue;
                }
                if ("shortDescription".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.shortDescription = reader.getString();
                    continue;
                }
                if ("lastModifiedTS".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.lastModifiedTS = reader.getString();
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.createTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.createdBy = reader.getString();
                    continue;
                }
                if ("updateTime".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.updateTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updatedBy".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.updatedBy = reader.getString();
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    List categories;
                    deserializedAtlasGlossaryExtInfo.categories = categories = reader.readArray(reader1 -> AtlasRelatedCategoryHeader.fromJson(reader1));
                    continue;
                }
                if ("language".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.language = reader.getString();
                    continue;
                }
                if ("terms".equals(fieldName)) {
                    List terms;
                    deserializedAtlasGlossaryExtInfo.terms = terms = reader.readArray(reader1 -> AtlasRelatedTermHeader.fromJson(reader1));
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    deserializedAtlasGlossaryExtInfo.usage = reader.getString();
                    continue;
                }
                if ("categoryInfo".equals(fieldName)) {
                    Map categoryInfo;
                    deserializedAtlasGlossaryExtInfo.categoryInfo = categoryInfo = reader.readMap(reader1 -> AtlasGlossaryCategory.fromJson(reader1));
                    continue;
                }
                if ("termInfo".equals(fieldName)) {
                    Map termInfo;
                    deserializedAtlasGlossaryExtInfo.termInfo = termInfo = reader.readMap(reader1 -> AtlasGlossaryTerm.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAtlasGlossaryExtInfo;
        });
    }
}

