/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap.models;

import com.azure.analytics.purview.datamap.models.AtlasClassification;
import com.azure.analytics.purview.datamap.models.AtlasTermAssignmentHeader;
import com.azure.analytics.purview.datamap.models.ContactInfo;
import com.azure.analytics.purview.datamap.models.EntityStatus;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AtlasEntity
implements JsonSerializable<AtlasEntity> {
    private Map<String, BinaryData> attributes;
    private String typeName;
    private String lastModifiedTS;
    private Map<String, BinaryData> businessAttributes;
    private List<AtlasClassification> classifications;
    private Long createTime;
    private String createdBy;
    private Map<String, String> customAttributes;
    private String guid;
    private String homeId;
    private String collectionId;
    private Boolean isIncomplete;
    private List<String> labels;
    private List<AtlasTermAssignmentHeader> meanings;
    private Integer provenanceType;
    private Boolean proxy;
    private Map<String, BinaryData> relationshipAttributes;
    private EntityStatus status;
    private Long updateTime;
    private String updatedBy;
    private Long version;
    private Map<String, List<ContactInfo>> contacts;

    public Map<String, BinaryData> getAttributes() {
        return this.attributes;
    }

    public AtlasEntity setAttributes(Map<String, BinaryData> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public AtlasEntity setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String getLastModifiedTS() {
        return this.lastModifiedTS;
    }

    public AtlasEntity setLastModifiedTS(String lastModifiedTS) {
        this.lastModifiedTS = lastModifiedTS;
        return this;
    }

    public Map<String, BinaryData> getBusinessAttributes() {
        return this.businessAttributes;
    }

    public AtlasEntity setBusinessAttributes(Map<String, BinaryData> businessAttributes) {
        this.businessAttributes = businessAttributes;
        return this;
    }

    public List<AtlasClassification> getClassifications() {
        return this.classifications;
    }

    public AtlasEntity setClassifications(List<AtlasClassification> classifications) {
        this.classifications = classifications;
        return this;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public AtlasEntity setCreateTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public AtlasEntity setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public AtlasEntity setCustomAttributes(Map<String, String> customAttributes) {
        this.customAttributes = customAttributes;
        return this;
    }

    public String getGuid() {
        return this.guid;
    }

    public AtlasEntity setGuid(String guid) {
        this.guid = guid;
        return this;
    }

    public String getHomeId() {
        return this.homeId;
    }

    public AtlasEntity setHomeId(String homeId) {
        this.homeId = homeId;
        return this;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public Boolean isIncomplete() {
        return this.isIncomplete;
    }

    public AtlasEntity setIsIncomplete(Boolean isIncomplete) {
        this.isIncomplete = isIncomplete;
        return this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public AtlasEntity setLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public List<AtlasTermAssignmentHeader> getMeanings() {
        return this.meanings;
    }

    public AtlasEntity setMeanings(List<AtlasTermAssignmentHeader> meanings) {
        this.meanings = meanings;
        return this;
    }

    public Integer getProvenanceType() {
        return this.provenanceType;
    }

    public AtlasEntity setProvenanceType(Integer provenanceType) {
        this.provenanceType = provenanceType;
        return this;
    }

    public Boolean isProxy() {
        return this.proxy;
    }

    public AtlasEntity setProxy(Boolean proxy) {
        this.proxy = proxy;
        return this;
    }

    public Map<String, BinaryData> getRelationshipAttributes() {
        return this.relationshipAttributes;
    }

    public AtlasEntity setRelationshipAttributes(Map<String, BinaryData> relationshipAttributes) {
        this.relationshipAttributes = relationshipAttributes;
        return this;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public AtlasEntity setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public AtlasEntity setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public AtlasEntity setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public AtlasEntity setVersion(Long version) {
        this.version = version;
        return this;
    }

    public Map<String, List<ContactInfo>> getContacts() {
        return this.contacts;
    }

    public AtlasEntity setContacts(Map<String, List<ContactInfo>> contacts) {
        this.contacts = contacts;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("attributes", this.attributes, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("lastModifiedTS", this.lastModifiedTS);
        jsonWriter.writeMapField("businessAttributes", this.businessAttributes, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeArrayField("classifications", this.classifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("createTime", (Number)this.createTime);
        jsonWriter.writeStringField("createdBy", this.createdBy);
        jsonWriter.writeMapField("customAttributes", this.customAttributes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("guid", this.guid);
        jsonWriter.writeStringField("homeId", this.homeId);
        jsonWriter.writeBooleanField("isIncomplete", this.isIncomplete);
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("meanings", this.meanings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("provenanceType", (Number)this.provenanceType);
        jsonWriter.writeBooleanField("proxy", this.proxy);
        jsonWriter.writeMapField("relationshipAttributes", this.relationshipAttributes, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeNumberField("updateTime", (Number)this.updateTime);
        jsonWriter.writeStringField("updatedBy", this.updatedBy);
        jsonWriter.writeNumberField("version", (Number)this.version);
        jsonWriter.writeMapField("contacts", this.contacts, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeJson((JsonSerializable)element1)));
        return jsonWriter.writeEndObject();
    }

    public static AtlasEntity fromJson(JsonReader jsonReader) throws IOException {
        return (AtlasEntity)jsonReader.readObject(reader -> {
            AtlasEntity deserializedAtlasEntity = new AtlasEntity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("attributes".equals(fieldName)) {
                    Map attributes;
                    deserializedAtlasEntity.attributes = attributes = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("typeName".equals(fieldName)) {
                    deserializedAtlasEntity.typeName = reader.getString();
                    continue;
                }
                if ("lastModifiedTS".equals(fieldName)) {
                    deserializedAtlasEntity.lastModifiedTS = reader.getString();
                    continue;
                }
                if ("businessAttributes".equals(fieldName)) {
                    Map businessAttributes;
                    deserializedAtlasEntity.businessAttributes = businessAttributes = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("classifications".equals(fieldName)) {
                    List classifications;
                    deserializedAtlasEntity.classifications = classifications = reader.readArray(reader1 -> AtlasClassification.fromJson(reader1));
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedAtlasEntity.createTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedAtlasEntity.createdBy = reader.getString();
                    continue;
                }
                if ("customAttributes".equals(fieldName)) {
                    Map customAttributes;
                    deserializedAtlasEntity.customAttributes = customAttributes = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("guid".equals(fieldName)) {
                    deserializedAtlasEntity.guid = reader.getString();
                    continue;
                }
                if ("homeId".equals(fieldName)) {
                    deserializedAtlasEntity.homeId = reader.getString();
                    continue;
                }
                if ("collectionId".equals(fieldName)) {
                    deserializedAtlasEntity.collectionId = reader.getString();
                    continue;
                }
                if ("isIncomplete".equals(fieldName)) {
                    deserializedAtlasEntity.isIncomplete = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    List labels;
                    deserializedAtlasEntity.labels = labels = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("meanings".equals(fieldName)) {
                    List meanings;
                    deserializedAtlasEntity.meanings = meanings = reader.readArray(reader1 -> AtlasTermAssignmentHeader.fromJson(reader1));
                    continue;
                }
                if ("provenanceType".equals(fieldName)) {
                    deserializedAtlasEntity.provenanceType = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("proxy".equals(fieldName)) {
                    deserializedAtlasEntity.proxy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("relationshipAttributes".equals(fieldName)) {
                    Map relationshipAttributes;
                    deserializedAtlasEntity.relationshipAttributes = relationshipAttributes = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAtlasEntity.status = EntityStatus.fromString(reader.getString());
                    continue;
                }
                if ("updateTime".equals(fieldName)) {
                    deserializedAtlasEntity.updateTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updatedBy".equals(fieldName)) {
                    deserializedAtlasEntity.updatedBy = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAtlasEntity.version = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("contacts".equals(fieldName)) {
                    Map contacts;
                    deserializedAtlasEntity.contacts = contacts = reader.readMap(reader1 -> reader1.readArray(reader2 -> ContactInfo.fromJson(reader2)));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAtlasEntity;
        });
    }
}

