/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.EntitiesImpl;
import com.azure.analytics.purview.datamap.implementation.MultipartFormDataHelper;
import com.azure.analytics.purview.datamap.models.AtlasClassification;
import com.azure.analytics.purview.datamap.models.AtlasClassifications;
import com.azure.analytics.purview.datamap.models.AtlasEntitiesWithExtInfo;
import com.azure.analytics.purview.datamap.models.AtlasEntityHeader;
import com.azure.analytics.purview.datamap.models.AtlasEntityHeaders;
import com.azure.analytics.purview.datamap.models.AtlasEntityWithExtInfo;
import com.azure.analytics.purview.datamap.models.BulkImportResult;
import com.azure.analytics.purview.datamap.models.BusinessAttributeUpdateBehavior;
import com.azure.analytics.purview.datamap.models.BusinessMetadataOptions;
import com.azure.analytics.purview.datamap.models.ClassificationAssociateOptions;
import com.azure.analytics.purview.datamap.models.EntityMutationResult;
import com.azure.analytics.purview.datamap.models.MoveEntitiesOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.TypeReference;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DataMapClientBuilder.class, isAsync=true)
public final class EntityAsyncClient {
    private final EntitiesImpl serviceClient;
    private static final TypeReference<List<String>> TYPE_REFERENCE_LIST_STRING = new TypeReference<List<String>>(){};

    EntityAsyncClient(EntitiesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getByIdsWithResponse(List<String> guid, RequestOptions requestOptions) {
        return this.serviceClient.getByIdsWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchCreateOrUpdateWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.batchCreateOrUpdateWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchDeleteWithResponse(List<String> guid, RequestOptions requestOptions) {
        return this.serviceClient.batchDeleteWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addClassificationWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.addClassificationWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateAttributeByIdWithResponse(String guid, String name, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateAttributeByIdWithResponseAsync(guid, name, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.deleteWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getClassificationWithResponse(String guid, String classificationName, RequestOptions requestOptions) {
        return this.serviceClient.getClassificationWithResponseAsync(guid, classificationName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeClassificationWithResponse(String guid, String classificationName, RequestOptions requestOptions) {
        return this.serviceClient.removeClassificationWithResponseAsync(guid, classificationName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getClassificationsWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getClassificationsWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addClassificationsWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.addClassificationsWithResponseAsync(guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateClassificationsWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateClassificationsWithResponseAsync(guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.getByUniqueAttributeWithResponseAsync(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateByUniqueAttributeWithResponse(String typeName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateByUniqueAttributeWithResponseAsync(typeName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.deleteByUniqueAttributeWithResponseAsync(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeClassificationByUniqueAttributeWithResponse(String typeName, String classificationName, RequestOptions requestOptions) {
        return this.serviceClient.removeClassificationByUniqueAttributeWithResponseAsync(typeName, classificationName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addClassificationsByUniqueAttributeWithResponse(String typeName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.addClassificationsByUniqueAttributeWithResponseAsync(typeName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateClassificationsUniqueByAttributeWithResponse(String typeName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.updateClassificationsUniqueByAttributeWithResponseAsync(typeName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchSetClassificationsWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.batchSetClassificationsWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> batchGetByUniqueAttributesWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.batchGetByUniqueAttributesWithResponseAsync(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getHeaderWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.getHeaderWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeBusinessMetadataWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.removeBusinessMetadataWithResponseAsync(guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addOrUpdateBusinessMetadataWithResponse(String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.addOrUpdateBusinessMetadataWithResponseAsync(guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeBusinessMetadataAttributesWithResponse(String businessMetadataName, String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.removeBusinessMetadataAttributesWithResponseAsync(businessMetadataName, guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addOrUpdateBusinessMetadataAttributesWithResponse(String businessMetadataName, String guid, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.addOrUpdateBusinessMetadataAttributesWithResponseAsync(businessMetadataName, guid, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getBusinessMetadataTemplateWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getBusinessMetadataTemplateWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> importBusinessMetadataWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.importBusinessMetadataWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeLabelsWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.removeLabelsWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setLabelsWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.setLabelsWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addLabelWithResponse(String guid, RequestOptions requestOptions) {
        return this.serviceClient.addLabelWithResponseAsync(guid, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeLabelsByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.removeLabelsByUniqueAttributeWithResponseAsync(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setLabelsByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.setLabelsByUniqueAttributeWithResponseAsync(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addLabelsByUniqueAttributeWithResponse(String typeName, RequestOptions requestOptions) {
        return this.serviceClient.addLabelsByUniqueAttributeWithResponseAsync(typeName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> moveEntitiesToCollectionWithResponse(String collectionId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.moveEntitiesToCollectionWithResponseAsync(collectionId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> createOrUpdate(AtlasEntityWithExtInfo body, BusinessAttributeUpdateBehavior businessAttributeUpdateBehavior, String collectionId) {
        RequestOptions requestOptions = new RequestOptions();
        if (businessAttributeUpdateBehavior != null) {
            requestOptions.addQueryParam("businessAttributeUpdateBehavior", businessAttributeUpdateBehavior.toString(), false);
        }
        if (collectionId != null) {
            requestOptions.addQueryParam("collectionId", collectionId, false);
        }
        return this.createOrUpdateWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> createOrUpdate(AtlasEntityWithExtInfo body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.createOrUpdateWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntitiesWithExtInfo> getByIds(List<String> guid, Boolean minExtInfo, Boolean ignoreRelationships) {
        RequestOptions requestOptions = new RequestOptions();
        if (minExtInfo != null) {
            requestOptions.addQueryParam("minExtInfo", String.valueOf(minExtInfo), false);
        }
        if (ignoreRelationships != null) {
            requestOptions.addQueryParam("ignoreRelationships", String.valueOf(ignoreRelationships), false);
        }
        return this.getByIdsWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntitiesWithExtInfo)protocolMethodData.toObject(AtlasEntitiesWithExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntitiesWithExtInfo> getByIds(List<String> guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getByIdsWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntitiesWithExtInfo)protocolMethodData.toObject(AtlasEntitiesWithExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> batchCreateOrUpdate(AtlasEntitiesWithExtInfo body, String collectionId, BusinessAttributeUpdateBehavior businessAttributeUpdateBehavior) {
        RequestOptions requestOptions = new RequestOptions();
        if (collectionId != null) {
            requestOptions.addQueryParam("collectionId", collectionId, false);
        }
        if (businessAttributeUpdateBehavior != null) {
            requestOptions.addQueryParam("businessAttributeUpdateBehavior", businessAttributeUpdateBehavior.toString(), false);
        }
        return this.batchCreateOrUpdateWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> batchCreateOrUpdate(AtlasEntitiesWithExtInfo body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.batchCreateOrUpdateWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> batchDelete(List<String> guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.batchDeleteWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addClassification(ClassificationAssociateOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.addClassificationWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntityWithExtInfo> get(String guid, Boolean minExtInfo, Boolean ignoreRelationships) {
        RequestOptions requestOptions = new RequestOptions();
        if (minExtInfo != null) {
            requestOptions.addQueryParam("minExtInfo", String.valueOf(minExtInfo), false);
        }
        if (ignoreRelationships != null) {
            requestOptions.addQueryParam("ignoreRelationships", String.valueOf(ignoreRelationships), false);
        }
        return this.getWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntityWithExtInfo)protocolMethodData.toObject(AtlasEntityWithExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntityWithExtInfo> get(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntityWithExtInfo)protocolMethodData.toObject(AtlasEntityWithExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> updateAttributeById(String guid, String name, BinaryData body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateAttributeByIdWithResponse(guid, name, body, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> delete(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasClassification> getClassification(String guid, String classificationName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getClassificationWithResponse(guid, classificationName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasClassification)protocolMethodData.toObject(AtlasClassification.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeClassification(String guid, String classificationName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.removeClassificationWithResponse(guid, classificationName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasClassifications> getClassifications(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getClassificationsWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasClassifications)protocolMethodData.toObject(AtlasClassifications.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addClassifications(String guid, List<AtlasClassification> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.addClassificationsWithResponse(guid, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateClassifications(String guid, List<AtlasClassification> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateClassificationsWithResponse(guid, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntityWithExtInfo> getByUniqueAttribute(String typeName, Boolean minExtInfo, Boolean ignoreRelationships, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (minExtInfo != null) {
            requestOptions.addQueryParam("minExtInfo", String.valueOf(minExtInfo), false);
        }
        if (ignoreRelationships != null) {
            requestOptions.addQueryParam("ignoreRelationships", String.valueOf(ignoreRelationships), false);
        }
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        return this.getByUniqueAttributeWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntityWithExtInfo)protocolMethodData.toObject(AtlasEntityWithExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntityWithExtInfo> getByUniqueAttribute(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getByUniqueAttributeWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntityWithExtInfo)protocolMethodData.toObject(AtlasEntityWithExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> updateByUniqueAttribute(String typeName, AtlasEntityWithExtInfo body, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        return this.updateByUniqueAttributeWithResponse(typeName, BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> updateByUniqueAttribute(String typeName, AtlasEntityWithExtInfo body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateByUniqueAttributeWithResponse(typeName, BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> deleteByUniqueAttribute(String typeName, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        return this.deleteByUniqueAttributeWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> deleteByUniqueAttribute(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteByUniqueAttributeWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeClassificationByUniqueAttribute(String typeName, String classificationName, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        return this.removeClassificationByUniqueAttributeWithResponse(typeName, classificationName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeClassificationByUniqueAttribute(String typeName, String classificationName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.removeClassificationByUniqueAttributeWithResponse(typeName, classificationName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addClassificationsByUniqueAttribute(String typeName, List<AtlasClassification> body, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        return this.addClassificationsByUniqueAttributeWithResponse(typeName, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addClassificationsByUniqueAttribute(String typeName, List<AtlasClassification> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.addClassificationsByUniqueAttributeWithResponse(typeName, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateClassificationsUniqueByAttribute(String typeName, List<AtlasClassification> body, String attribute) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        return this.updateClassificationsUniqueByAttributeWithResponse(typeName, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateClassificationsUniqueByAttribute(String typeName, List<AtlasClassification> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.updateClassificationsUniqueByAttributeWithResponse(typeName, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> batchSetClassifications(AtlasEntityHeaders body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.batchSetClassificationsWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (List)protocolMethodData.toObject(TYPE_REFERENCE_LIST_STRING));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntitiesWithExtInfo> batchGetByUniqueAttributes(String typeName, Boolean minExtInfo, Boolean ignoreRelationships, String attrNQualifiedName) {
        RequestOptions requestOptions = new RequestOptions();
        if (minExtInfo != null) {
            requestOptions.addQueryParam("minExtInfo", String.valueOf(minExtInfo), false);
        }
        if (ignoreRelationships != null) {
            requestOptions.addQueryParam("ignoreRelationships", String.valueOf(ignoreRelationships), false);
        }
        if (attrNQualifiedName != null) {
            requestOptions.addQueryParam("attr_N:qualifiedName", attrNQualifiedName, false);
        }
        return this.batchGetByUniqueAttributesWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntitiesWithExtInfo)protocolMethodData.toObject(AtlasEntitiesWithExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntitiesWithExtInfo> batchGetByUniqueAttributes(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.batchGetByUniqueAttributesWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntitiesWithExtInfo)protocolMethodData.toObject(AtlasEntitiesWithExtInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AtlasEntityHeader> getHeader(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getHeaderWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AtlasEntityHeader)protocolMethodData.toObject(AtlasEntityHeader.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeBusinessMetadata(String guid, Map<String, Map<String, BinaryData>> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.removeBusinessMetadataWithResponse(guid, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addOrUpdateBusinessMetadata(String guid, Map<String, Map<String, BinaryData>> body, Boolean overwrite) {
        RequestOptions requestOptions = new RequestOptions();
        if (overwrite != null) {
            requestOptions.addQueryParam("isOverwrite", String.valueOf(overwrite), false);
        }
        return this.addOrUpdateBusinessMetadataWithResponse(guid, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addOrUpdateBusinessMetadata(String guid, Map<String, Map<String, BinaryData>> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.addOrUpdateBusinessMetadataWithResponse(guid, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeBusinessMetadataAttributes(String businessMetadataName, String guid, Map<String, BinaryData> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.removeBusinessMetadataAttributesWithResponse(businessMetadataName, guid, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addOrUpdateBusinessMetadataAttributes(String businessMetadataName, String guid, Map<String, BinaryData> body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.addOrUpdateBusinessMetadataAttributesWithResponse(businessMetadataName, guid, BinaryData.fromObject(body), requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getBusinessMetadataTemplate() {
        RequestOptions requestOptions = new RequestOptions();
        return this.getBusinessMetadataTemplateWithResponse(requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BulkImportResult> importBusinessMetadata(BusinessMetadataOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.importBusinessMetadataWithResponse(new MultipartFormDataHelper(requestOptions).serializeFileField("file", body.getFile().getContent(), body.getFile().getContentType(), body.getFile().getFilename()).end().getRequestBody(), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (BulkImportResult)protocolMethodData.toObject(BulkImportResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeLabels(String guid, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        return this.removeLabelsWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeLabels(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.removeLabelsWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setLabels(String guid, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        return this.setLabelsWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setLabels(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.setLabelsWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addLabel(String guid, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        return this.addLabelWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addLabel(String guid) {
        RequestOptions requestOptions = new RequestOptions();
        return this.addLabelWithResponse(guid, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeLabelsByUniqueAttribute(String typeName, String attribute, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        return this.removeLabelsByUniqueAttributeWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeLabelsByUniqueAttribute(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.removeLabelsByUniqueAttributeWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setLabelsByUniqueAttribute(String typeName, String attribute, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        return this.setLabelsByUniqueAttributeWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setLabelsByUniqueAttribute(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.setLabelsByUniqueAttributeWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addLabelsByUniqueAttribute(String typeName, String attribute, List<String> body) {
        RequestOptions requestOptions = new RequestOptions();
        if (attribute != null) {
            requestOptions.addQueryParam("attr:qualifiedName", attribute, false);
        }
        if (body != null) {
            requestOptions.setBody(BinaryData.fromObject(body));
        }
        return this.addLabelsByUniqueAttributeWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addLabelsByUniqueAttribute(String typeName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.addLabelsByUniqueAttributeWithResponse(typeName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EntityMutationResult> moveEntitiesToCollection(String collectionId, MoveEntitiesOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.moveEntitiesToCollectionWithResponse(collectionId, BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EntityMutationResult)protocolMethodData.toObject(EntityMutationResult.class));
    }
}

