/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.purview.datamap;

import com.azure.analytics.purview.datamap.DataMapClientBuilder;
import com.azure.analytics.purview.datamap.implementation.DiscoveriesImpl;
import com.azure.analytics.purview.datamap.models.AutoCompleteOptions;
import com.azure.analytics.purview.datamap.models.AutoCompleteResult;
import com.azure.analytics.purview.datamap.models.QueryOptions;
import com.azure.analytics.purview.datamap.models.QueryResult;
import com.azure.analytics.purview.datamap.models.SuggestOptions;
import com.azure.analytics.purview.datamap.models.SuggestResult;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

@ServiceClient(builder=DataMapClientBuilder.class)
public final class DiscoveryClient {
    private final DiscoveriesImpl serviceClient;

    DiscoveryClient(DiscoveriesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> queryWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.queryWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> suggestWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.suggestWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> autoCompleteWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.autoCompleteWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueryResult query(QueryOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return (QueryResult)((BinaryData)this.queryWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(QueryResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SuggestResult suggest(SuggestOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return (SuggestResult)((BinaryData)this.suggestWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(SuggestResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoCompleteResult autoComplete(AutoCompleteOptions body) {
        RequestOptions requestOptions = new RequestOptions();
        return (AutoCompleteResult)((BinaryData)this.autoCompleteWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(AutoCompleteResult.class);
    }
}

