/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation.models;

import com.azure.analytics.onlineexperimentation.implementation.JsonMergePatchHelper;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricType;
import com.azure.analytics.onlineexperimentation.models.ObservedEvent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class UserRateMetricDefinition
extends ExperimentMetricDefinition {
    private ExperimentMetricType type = ExperimentMetricType.USER_RATE;
    private ObservedEvent startEvent;
    private ObservedEvent endEvent;
    private final Set<String> updatedProperties = new HashSet<String>();

    @Override
    public ExperimentMetricType getType() {
        return this.type;
    }

    public ObservedEvent getStartEvent() {
        return this.startEvent;
    }

    public UserRateMetricDefinition setStartEvent(ObservedEvent startEvent) {
        this.startEvent = startEvent;
        this.updatedProperties.add("startEvent");
        return this;
    }

    public ObservedEvent getEndEvent() {
        return this.endEvent;
    }

    public UserRateMetricDefinition setEndEvent(ObservedEvent endEvent) {
        this.endEvent = endEvent;
        this.updatedProperties.add("endEvent");
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (JsonMergePatchHelper.getExperimentMetricDefinitionAccessor().isJsonMergePatch(this)) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("startEvent", (JsonSerializable)this.startEvent);
        jsonWriter.writeJsonField("endEvent", (JsonSerializable)this.endEvent);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type.toString());
        if (this.updatedProperties.contains("startEvent")) {
            if (this.startEvent == null) {
                jsonWriter.writeNullField("startEvent");
            } else {
                JsonMergePatchHelper.getObservedEventAccessor().prepareModelForJsonMergePatch(this.startEvent, true);
                jsonWriter.writeJsonField("startEvent", (JsonSerializable)this.startEvent);
                JsonMergePatchHelper.getObservedEventAccessor().prepareModelForJsonMergePatch(this.startEvent, false);
            }
        }
        if (this.updatedProperties.contains("endEvent")) {
            if (this.endEvent == null) {
                jsonWriter.writeNullField("endEvent");
            } else {
                JsonMergePatchHelper.getObservedEventAccessor().prepareModelForJsonMergePatch(this.endEvent, true);
                jsonWriter.writeJsonField("endEvent", (JsonSerializable)this.endEvent);
                JsonMergePatchHelper.getObservedEventAccessor().prepareModelForJsonMergePatch(this.endEvent, false);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static UserRateMetricDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (UserRateMetricDefinition)jsonReader.readObject(reader -> {
            UserRateMetricDefinition deserializedUserRateMetricDefinition = new UserRateMetricDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedUserRateMetricDefinition.type = ExperimentMetricType.fromString(reader.getString());
                    continue;
                }
                if ("startEvent".equals(fieldName)) {
                    deserializedUserRateMetricDefinition.startEvent = ObservedEvent.fromJson(reader);
                    continue;
                }
                if ("endEvent".equals(fieldName)) {
                    deserializedUserRateMetricDefinition.endEvent = ObservedEvent.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserRateMetricDefinition;
        });
    }
}

