/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation.models;

import com.azure.analytics.onlineexperimentation.implementation.JsonMergePatchHelper;
import com.azure.analytics.onlineexperimentation.models.AggregatedValue;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class PercentileMetricDefinition
extends ExperimentMetricDefinition {
    private ExperimentMetricType type = ExperimentMetricType.PERCENTILE;
    private AggregatedValue value;
    private double percentile;
    private final Set<String> updatedProperties = new HashSet<String>();

    @Override
    public ExperimentMetricType getType() {
        return this.type;
    }

    public AggregatedValue getValue() {
        return this.value;
    }

    public PercentileMetricDefinition setValue(AggregatedValue value) {
        this.value = value;
        this.updatedProperties.add("value");
        return this;
    }

    public double getPercentile() {
        return this.percentile;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (JsonMergePatchHelper.getExperimentMetricDefinitionAccessor().isJsonMergePatch(this)) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("value", (JsonSerializable)this.value);
        jsonWriter.writeDoubleField("percentile", this.percentile);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type.toString());
        if (this.updatedProperties.contains("value")) {
            if (this.value == null) {
                jsonWriter.writeNullField("value");
            } else {
                JsonMergePatchHelper.getAggregatedValueAccessor().prepareModelForJsonMergePatch(this.value, true);
                jsonWriter.writeJsonField("value", (JsonSerializable)this.value);
                JsonMergePatchHelper.getAggregatedValueAccessor().prepareModelForJsonMergePatch(this.value, false);
            }
        }
        if (this.updatedProperties.contains("percentile")) {
            jsonWriter.writeDoubleField("percentile", this.percentile);
        }
        return jsonWriter.writeEndObject();
    }

    public static PercentileMetricDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (PercentileMetricDefinition)jsonReader.readObject(reader -> {
            PercentileMetricDefinition deserializedPercentileMetricDefinition = new PercentileMetricDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedPercentileMetricDefinition.type = ExperimentMetricType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedPercentileMetricDefinition.value = AggregatedValue.fromJson(reader);
                    continue;
                }
                if ("percentile".equals(fieldName)) {
                    deserializedPercentileMetricDefinition.percentile = reader.getDouble();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPercentileMetricDefinition;
        });
    }

    public PercentileMetricDefinition setPercentile(double percentile) {
        this.percentile = percentile;
        this.updatedProperties.add("percentile");
        return this;
    }
}

