/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation.models;

import com.azure.analytics.onlineexperimentation.implementation.JsonMergePatchHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class ObservedEvent
implements JsonSerializable<ObservedEvent> {
    private String eventName;
    private String filter;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public ObservedEvent() {
    }

    public ObservedEvent(String eventName) {
        this.setEventName(eventName);
    }

    public String getEventName() {
        return this.eventName;
    }

    public ObservedEvent setEventName(String eventName) {
        this.eventName = eventName;
        this.updatedProperties.add("eventName");
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public ObservedEvent setFilter(String filter) {
        this.filter = filter;
        this.updatedProperties.add("filter");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("eventName", this.eventName);
        jsonWriter.writeStringField("filter", this.filter);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("eventName")) {
            if (this.eventName == null) {
                jsonWriter.writeNullField("eventName");
            } else {
                jsonWriter.writeStringField("eventName", this.eventName);
            }
        }
        if (this.updatedProperties.contains("filter")) {
            if (this.filter == null) {
                jsonWriter.writeNullField("filter");
            } else {
                jsonWriter.writeStringField("filter", this.filter);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ObservedEvent fromJson(JsonReader jsonReader) throws IOException {
        return (ObservedEvent)jsonReader.readObject(reader -> {
            ObservedEvent deserializedObservedEvent = new ObservedEvent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("eventName".equals(fieldName)) {
                    deserializedObservedEvent.eventName = reader.getString();
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedObservedEvent.filter = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedObservedEvent;
        });
    }

    static {
        JsonMergePatchHelper.setObservedEventAccessor(new JsonMergePatchHelper.ObservedEventAccessor(){

            @Override
            public ObservedEvent prepareModelForJsonMergePatch(ObservedEvent model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(ObservedEvent model) {
                return model.jsonMergePatch;
            }
        });
    }
}

