/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation.models;

import com.azure.analytics.onlineexperimentation.models.DiagnosticDetail;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ExperimentMetricValidationResult
implements JsonSerializable<ExperimentMetricValidationResult> {
    private List<DiagnosticDetail> diagnostics;
    private final boolean isValid;

    public List<DiagnosticDetail> getDiagnostics() {
        return this.diagnostics;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isValid", this.isValid);
        return jsonWriter.writeEndObject();
    }

    public static ExperimentMetricValidationResult fromJson(JsonReader jsonReader) throws IOException {
        return (ExperimentMetricValidationResult)jsonReader.readObject(reader -> {
            boolean isValid = false;
            List diagnostics = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isValid".equals(fieldName)) {
                    isValid = reader.getBoolean();
                    continue;
                }
                if ("diagnostics".equals(fieldName)) {
                    diagnostics = reader.readArray(reader1 -> DiagnosticDetail.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            ExperimentMetricValidationResult deserializedExperimentMetricValidationResult = new ExperimentMetricValidationResult(isValid);
            deserializedExperimentMetricValidationResult.diagnostics = diagnostics;
            return deserializedExperimentMetricValidationResult;
        });
    }

    private ExperimentMetricValidationResult(boolean isValid) {
        this.isValid = isValid;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

