/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation.models;

import com.azure.analytics.onlineexperimentation.implementation.JsonMergePatchHelper;
import com.azure.analytics.onlineexperimentation.models.AverageMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.EventCountMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.EventRateMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricType;
import com.azure.analytics.onlineexperimentation.models.PercentileMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.SumMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.UserCountMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.UserRateMetricDefinition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ExperimentMetricDefinition
implements JsonSerializable<ExperimentMetricDefinition> {
    private ExperimentMetricType type = ExperimentMetricType.fromString("ExperimentMetricDefinition");
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public ExperimentMetricType getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ExperimentMetricDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ExperimentMetricDefinition)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ExperimentMetricDefinition experimentMetricDefinition;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("EventCount".equals(discriminatorValue)) {
                    experimentMetricDefinition = EventCountMetricDefinition.fromJson(readerToUse.reset());
                    return experimentMetricDefinition;
                }
                if ("UserCount".equals(discriminatorValue)) {
                    experimentMetricDefinition = UserCountMetricDefinition.fromJson(readerToUse.reset());
                    return experimentMetricDefinition;
                }
                if ("EventRate".equals(discriminatorValue)) {
                    experimentMetricDefinition = EventRateMetricDefinition.fromJson(readerToUse.reset());
                    return experimentMetricDefinition;
                }
                if ("UserRate".equals(discriminatorValue)) {
                    experimentMetricDefinition = UserRateMetricDefinition.fromJson(readerToUse.reset());
                    return experimentMetricDefinition;
                }
                if ("Sum".equals(discriminatorValue)) {
                    experimentMetricDefinition = SumMetricDefinition.fromJson(readerToUse.reset());
                    return experimentMetricDefinition;
                }
                if ("Average".equals(discriminatorValue)) {
                    experimentMetricDefinition = AverageMetricDefinition.fromJson(readerToUse.reset());
                    return experimentMetricDefinition;
                }
                if ("Percentile".equals(discriminatorValue)) {
                    experimentMetricDefinition = PercentileMetricDefinition.fromJson(readerToUse.reset());
                    return experimentMetricDefinition;
                }
                experimentMetricDefinition = ExperimentMetricDefinition.fromJsonKnownDiscriminator(readerToUse.reset());
                return experimentMetricDefinition;
            }
        });
    }

    static ExperimentMetricDefinition fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ExperimentMetricDefinition)jsonReader.readObject(reader -> {
            ExperimentMetricDefinition deserializedExperimentMetricDefinition = new ExperimentMetricDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedExperimentMetricDefinition.type = ExperimentMetricType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExperimentMetricDefinition;
        });
    }

    static {
        JsonMergePatchHelper.setExperimentMetricDefinitionAccessor(new JsonMergePatchHelper.ExperimentMetricDefinitionAccessor(){

            @Override
            public ExperimentMetricDefinition prepareModelForJsonMergePatch(ExperimentMetricDefinition model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(ExperimentMetricDefinition model) {
                return model.jsonMergePatch;
            }
        });
    }
}

