/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation.models;

import com.azure.analytics.onlineexperimentation.implementation.JsonMergePatchHelper;
import com.azure.analytics.onlineexperimentation.models.DesiredDirection;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.LifecycleStage;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ExperimentMetric
implements JsonSerializable<ExperimentMetric> {
    private String id;
    private LifecycleStage lifecycle;
    private String displayName;
    private String description;
    private List<String> categories;
    private DesiredDirection desiredDirection;
    private ExperimentMetricDefinition definition;
    private String eTag;
    private OffsetDateTime lastModifiedAt;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleStage getLifecycle() {
        return this.lifecycle;
    }

    public ExperimentMetric setLifecycle(LifecycleStage lifecycle) {
        this.lifecycle = lifecycle;
        this.updatedProperties.add("lifecycle");
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ExperimentMetric setDisplayName(String displayName) {
        this.displayName = displayName;
        this.updatedProperties.add("displayName");
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ExperimentMetric setDescription(String description) {
        this.description = description;
        this.updatedProperties.add("description");
        return this;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public ExperimentMetric setCategories(List<String> categories) {
        this.categories = categories;
        this.updatedProperties.add("categories");
        return this;
    }

    public DesiredDirection getDesiredDirection() {
        return this.desiredDirection;
    }

    public ExperimentMetric setDesiredDirection(DesiredDirection desiredDirection) {
        this.desiredDirection = desiredDirection;
        this.updatedProperties.add("desiredDirection");
        return this;
    }

    public ExperimentMetricDefinition getDefinition() {
        return this.definition;
    }

    public ExperimentMetric setDefinition(ExperimentMetricDefinition definition) {
        this.definition = definition;
        this.updatedProperties.add("definition");
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lifecycle", this.lifecycle == null ? null : this.lifecycle.toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("categories", this.categories, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("desiredDirection", this.desiredDirection == null ? null : this.desiredDirection.toString());
        jsonWriter.writeJsonField("definition", (JsonSerializable)this.definition);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("lifecycle")) {
            if (this.lifecycle == null) {
                jsonWriter.writeNullField("lifecycle");
            } else {
                jsonWriter.writeStringField("lifecycle", this.lifecycle.toString());
            }
        }
        if (this.updatedProperties.contains("displayName")) {
            if (this.displayName == null) {
                jsonWriter.writeNullField("displayName");
            } else {
                jsonWriter.writeStringField("displayName", this.displayName);
            }
        }
        if (this.updatedProperties.contains("description")) {
            if (this.description == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.description);
            }
        }
        if (this.updatedProperties.contains("categories")) {
            if (this.categories == null) {
                jsonWriter.writeNullField("categories");
            } else {
                jsonWriter.writeArrayField("categories", this.categories, (writer, element) -> writer.writeString(element));
            }
        }
        if (this.updatedProperties.contains("desiredDirection")) {
            if (this.desiredDirection == null) {
                jsonWriter.writeNullField("desiredDirection");
            } else {
                jsonWriter.writeStringField("desiredDirection", this.desiredDirection.toString());
            }
        }
        if (this.updatedProperties.contains("definition")) {
            if (this.definition == null) {
                jsonWriter.writeNullField("definition");
            } else {
                JsonMergePatchHelper.getExperimentMetricDefinitionAccessor().prepareModelForJsonMergePatch(this.definition, true);
                jsonWriter.writeJsonField("definition", (JsonSerializable)this.definition);
                JsonMergePatchHelper.getExperimentMetricDefinitionAccessor().prepareModelForJsonMergePatch(this.definition, false);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExperimentMetric fromJson(JsonReader jsonReader) throws IOException {
        return (ExperimentMetric)jsonReader.readObject(reader -> {
            ExperimentMetric deserializedExperimentMetric = new ExperimentMetric();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExperimentMetric.id = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedExperimentMetric.eTag = reader.getString();
                    continue;
                }
                if ("lastModifiedAt".equals(fieldName)) {
                    deserializedExperimentMetric.lastModifiedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lifecycle".equals(fieldName)) {
                    deserializedExperimentMetric.lifecycle = LifecycleStage.fromString(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedExperimentMetric.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExperimentMetric.description = reader.getString();
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    List categories;
                    deserializedExperimentMetric.categories = categories = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("desiredDirection".equals(fieldName)) {
                    deserializedExperimentMetric.desiredDirection = DesiredDirection.fromString(reader.getString());
                    continue;
                }
                if ("definition".equals(fieldName)) {
                    deserializedExperimentMetric.definition = ExperimentMetricDefinition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExperimentMetric;
        });
    }

    static {
        JsonMergePatchHelper.setExperimentMetricAccessor(new JsonMergePatchHelper.ExperimentMetricAccessor(){

            @Override
            public ExperimentMetric prepareModelForJsonMergePatch(ExperimentMetric model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(ExperimentMetric model) {
                return model.jsonMergePatch;
            }
        });
    }
}

