/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation.models;

import com.azure.analytics.onlineexperimentation.implementation.JsonMergePatchHelper;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricType;
import com.azure.analytics.onlineexperimentation.models.ObservedEvent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class EventCountMetricDefinition
extends ExperimentMetricDefinition {
    private ExperimentMetricType type = ExperimentMetricType.EVENT_COUNT;
    private ObservedEvent event;
    private final Set<String> updatedProperties = new HashSet<String>();

    @Override
    public ExperimentMetricType getType() {
        return this.type;
    }

    public ObservedEvent getEvent() {
        return this.event;
    }

    public EventCountMetricDefinition setEvent(ObservedEvent event) {
        this.event = event;
        this.updatedProperties.add("event");
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (JsonMergePatchHelper.getExperimentMetricDefinitionAccessor().isJsonMergePatch(this)) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("event", (JsonSerializable)this.event);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type.toString());
        if (this.updatedProperties.contains("event")) {
            if (this.event == null) {
                jsonWriter.writeNullField("event");
            } else {
                JsonMergePatchHelper.getObservedEventAccessor().prepareModelForJsonMergePatch(this.event, true);
                jsonWriter.writeJsonField("event", (JsonSerializable)this.event);
                JsonMergePatchHelper.getObservedEventAccessor().prepareModelForJsonMergePatch(this.event, false);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static EventCountMetricDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (EventCountMetricDefinition)jsonReader.readObject(reader -> {
            EventCountMetricDefinition deserializedEventCountMetricDefinition = new EventCountMetricDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedEventCountMetricDefinition.type = ExperimentMetricType.fromString(reader.getString());
                    continue;
                }
                if ("event".equals(fieldName)) {
                    deserializedEventCountMetricDefinition.event = ObservedEvent.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventCountMetricDefinition;
        });
    }
}

