/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation.models;

import com.azure.analytics.onlineexperimentation.implementation.JsonMergePatchHelper;
import com.azure.analytics.onlineexperimentation.models.AggregatedValue;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricDefinition;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class AverageMetricDefinition
extends ExperimentMetricDefinition {
    private ExperimentMetricType type = ExperimentMetricType.AVERAGE;
    private AggregatedValue value;
    private final Set<String> updatedProperties = new HashSet<String>();

    @Override
    public ExperimentMetricType getType() {
        return this.type;
    }

    public AggregatedValue getValue() {
        return this.value;
    }

    public AverageMetricDefinition setValue(AggregatedValue value) {
        this.value = value;
        this.updatedProperties.add("value");
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (JsonMergePatchHelper.getExperimentMetricDefinitionAccessor().isJsonMergePatch(this)) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("value", (JsonSerializable)this.value);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type.toString());
        if (this.updatedProperties.contains("value")) {
            if (this.value == null) {
                jsonWriter.writeNullField("value");
            } else {
                JsonMergePatchHelper.getAggregatedValueAccessor().prepareModelForJsonMergePatch(this.value, true);
                jsonWriter.writeJsonField("value", (JsonSerializable)this.value);
                JsonMergePatchHelper.getAggregatedValueAccessor().prepareModelForJsonMergePatch(this.value, false);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AverageMetricDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (AverageMetricDefinition)jsonReader.readObject(reader -> {
            AverageMetricDefinition deserializedAverageMetricDefinition = new AverageMetricDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedAverageMetricDefinition.type = ExperimentMetricType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedAverageMetricDefinition.value = AggregatedValue.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAverageMetricDefinition;
        });
    }
}

