/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation.models;

import com.azure.analytics.onlineexperimentation.implementation.JsonMergePatchHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class AggregatedValue
implements JsonSerializable<AggregatedValue> {
    private String eventName;
    private String filter;
    private String eventProperty;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getEventName() {
        return this.eventName;
    }

    public AggregatedValue setEventName(String eventName) {
        this.eventName = eventName;
        this.updatedProperties.add("eventName");
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public AggregatedValue setFilter(String filter) {
        this.filter = filter;
        this.updatedProperties.add("filter");
        return this;
    }

    public String getEventProperty() {
        return this.eventProperty;
    }

    public AggregatedValue setEventProperty(String eventProperty) {
        this.eventProperty = eventProperty;
        this.updatedProperties.add("eventProperty");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("eventName", this.eventName);
        jsonWriter.writeStringField("filter", this.filter);
        jsonWriter.writeStringField("eventProperty", this.eventProperty);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("eventName")) {
            if (this.eventName == null) {
                jsonWriter.writeNullField("eventName");
            } else {
                jsonWriter.writeStringField("eventName", this.eventName);
            }
        }
        if (this.updatedProperties.contains("filter")) {
            if (this.filter == null) {
                jsonWriter.writeNullField("filter");
            } else {
                jsonWriter.writeStringField("filter", this.filter);
            }
        }
        if (this.updatedProperties.contains("eventProperty")) {
            if (this.eventProperty == null) {
                jsonWriter.writeNullField("eventProperty");
            } else {
                jsonWriter.writeStringField("eventProperty", this.eventProperty);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AggregatedValue fromJson(JsonReader jsonReader) throws IOException {
        return (AggregatedValue)jsonReader.readObject(reader -> {
            AggregatedValue deserializedAggregatedValue = new AggregatedValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("eventName".equals(fieldName)) {
                    deserializedAggregatedValue.eventName = reader.getString();
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedAggregatedValue.filter = reader.getString();
                    continue;
                }
                if ("eventProperty".equals(fieldName)) {
                    deserializedAggregatedValue.eventProperty = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAggregatedValue;
        });
    }

    static {
        JsonMergePatchHelper.setAggregatedValueAccessor(new JsonMergePatchHelper.AggregatedValueAccessor(){

            @Override
            public AggregatedValue prepareModelForJsonMergePatch(AggregatedValue model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(AggregatedValue model) {
                return model.jsonMergePatch;
            }
        });
    }
}

