/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation.implementation;

import com.azure.analytics.onlineexperimentation.OnlineExperimentationServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class OnlineExperimentationClientImpl {
    private final OnlineExperimentationClientService service;
    private final String endpoint;
    private final OnlineExperimentationServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public OnlineExperimentationServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public OnlineExperimentationClientImpl(String endpoint, OnlineExperimentationServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public OnlineExperimentationClientImpl(HttpPipeline httpPipeline, String endpoint, OnlineExperimentationServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public OnlineExperimentationClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, OnlineExperimentationServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (OnlineExperimentationClientService)RestProxy.create(OnlineExperimentationClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMetricWithResponseAsync(String experimentMetricId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMetric(this.getEndpoint(), this.getServiceVersion().getVersion(), experimentMetricId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMetricWithResponse(String experimentMetricId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getMetricSync(this.getEndpoint(), this.getServiceVersion().getVersion(), experimentMetricId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateMetricWithResponseAsync(String experimentMetricId, BinaryData resource, RequestOptions requestOptions) {
        String contentType = "application/merge-patch+json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateMetric(this.getEndpoint(), this.getServiceVersion().getVersion(), experimentMetricId, "application/merge-patch+json", "application/json", resource, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateMetricWithResponse(String experimentMetricId, BinaryData resource, RequestOptions requestOptions) {
        String contentType = "application/merge-patch+json";
        String accept = "application/json";
        return this.service.createOrUpdateMetricSync(this.getEndpoint(), this.getServiceVersion().getVersion(), experimentMetricId, "application/merge-patch+json", "application/json", resource, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> validateMetricWithResponseAsync(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateMetric(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> validateMetricWithResponse(BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.validateMetricSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteMetricWithResponseAsync(String experimentMetricId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteMetric(this.getEndpoint(), this.getServiceVersion().getVersion(), experimentMetricId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteMetricWithResponse(String experimentMetricId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteMetricSync(this.getEndpoint(), this.getServiceVersion().getVersion(), experimentMetricId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listMetricsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetrics(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMetricsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxpagesize", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listMetricsSinglePageAsync(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxpagesize", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listMetricsNextSinglePageAsync((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listMetricsSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listMetricsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMetrics(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(pageSize -> {
            RequestOptions requestOptionsLocal;
            RequestOptions requestOptions2 = requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxpagesize", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listMetricsSinglePage(requestOptionsLocal);
        }, (nextLink, pageSize) -> {
            RequestOptions requestOptionsLocal = new RequestOptions();
            requestOptionsLocal.setContext(requestOptionsForNextPage.getContext());
            if (pageSize != null) {
                requestOptionsLocal.addRequestCallback(requestLocal -> {
                    UrlBuilder urlBuilder = UrlBuilder.parse((URL)requestLocal.getUrl());
                    urlBuilder.setQueryParameter("maxpagesize", String.valueOf(pageSize));
                    requestLocal.setUrl(urlBuilder.toString());
                });
            }
            return this.listMetricsNextSinglePage((String)nextLink, requestOptionsLocal);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listMetricsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetricsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listMetricsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listMetricsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="OnlineExperimentationClient")
    public static interface OnlineExperimentationClientService {
        @Get(value="/experiment-metrics/{experimentMetricId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getMetric(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="experimentMetricId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/experiment-metrics/{experimentMetricId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getMetricSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="experimentMetricId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Patch(value="/experiment-metrics/{experimentMetricId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createOrUpdateMetric(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="experimentMetricId") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/merge-patch+json") BinaryData var6, RequestOptions var7, Context var8);

        @Patch(value="/experiment-metrics/{experimentMetricId}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createOrUpdateMetricSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="experimentMetricId") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/merge-patch+json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/experiment-metrics:validate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> validateMetric(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/experiment-metrics:validate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> validateMetricSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Delete(value="/experiment-metrics/{experimentMetricId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteMetric(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="experimentMetricId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Delete(value="/experiment-metrics/{experimentMetricId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteMetricSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="experimentMetricId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/experiment-metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listMetrics(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/experiment-metrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listMetricsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listMetricsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listMetricsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

