/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation;

import com.azure.analytics.onlineexperimentation.OnlineExperimentationClientBuilder;
import com.azure.analytics.onlineexperimentation.implementation.JsonMergePatchHelper;
import com.azure.analytics.onlineexperimentation.implementation.OnlineExperimentationClientImpl;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetric;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricValidationResult;
import com.azure.analytics.onlineexperimentation.models.LifecycleStage;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.ETag;
import java.time.OffsetDateTime;

@ServiceClient(builder=OnlineExperimentationClientBuilder.class)
public final class OnlineExperimentationClient {
    private final OnlineExperimentationClientImpl serviceClient;

    OnlineExperimentationClient(OnlineExperimentationClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMetricWithResponse(String experimentMetricId, RequestOptions requestOptions) {
        return this.serviceClient.getMetricWithResponse(experimentMetricId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateMetricWithResponse(String experimentMetricId, BinaryData resource, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateMetricWithResponse(experimentMetricId, resource, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> validateMetricWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.validateMetricWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteMetricWithResponse(String experimentMetricId, RequestOptions requestOptions) {
        return this.serviceClient.deleteMetricWithResponse(experimentMetricId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMetrics(RequestOptions requestOptions) {
        return this.serviceClient.listMetrics(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric getMetric(String experimentMetricId, RequestConditions requestConditions) {
        OffsetDateTime ifModifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        OffsetDateTime offsetDateTime = ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        return (ExperimentMetric)((BinaryData)this.getMetricWithResponse(experimentMetricId, requestOptions).getValue()).toObject(ExperimentMetric.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric getMetric(String experimentMetricId) {
        RequestOptions requestOptions = new RequestOptions();
        return (ExperimentMetric)((BinaryData)this.getMetricWithResponse(experimentMetricId, requestOptions).getValue()).toObject(ExperimentMetric.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric createOrUpdateMetric(String experimentMetricId, ExperimentMetric resource, RequestConditions requestConditions) {
        OffsetDateTime ifModifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        OffsetDateTime offsetDateTime = ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, true);
        BinaryData resourceInBinaryData = BinaryData.fromObject((Object)resource);
        resourceInBinaryData.getLength();
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, false);
        return (ExperimentMetric)((BinaryData)this.createOrUpdateMetricWithResponse(experimentMetricId, resourceInBinaryData, requestOptions).getValue()).toObject(ExperimentMetric.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric createOrUpdateMetric(String experimentMetricId, ExperimentMetric resource) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, true);
        BinaryData resourceInBinaryData = BinaryData.fromObject((Object)resource);
        resourceInBinaryData.getLength();
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, false);
        return (ExperimentMetric)((BinaryData)this.createOrUpdateMetricWithResponse(experimentMetricId, resourceInBinaryData, requestOptions).getValue()).toObject(ExperimentMetric.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetricValidationResult validateMetric(ExperimentMetric body) {
        RequestOptions requestOptions = new RequestOptions();
        return (ExperimentMetricValidationResult)((BinaryData)this.validateMetricWithResponse(BinaryData.fromObject((Object)body), requestOptions).getValue()).toObject(ExperimentMetricValidationResult.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteMetric(String experimentMetricId, RequestConditions requestConditions) {
        OffsetDateTime ifModifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        OffsetDateTime offsetDateTime = ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        this.deleteMetricWithResponse(experimentMetricId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteMetric(String experimentMetricId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteMetricWithResponse(experimentMetricId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ExperimentMetric> listMetrics(Integer top, Integer skip) {
        RequestOptions requestOptions = new RequestOptions();
        if (top != null) {
            requestOptions.addQueryParam("top", String.valueOf(top), false);
        }
        if (skip != null) {
            requestOptions.addQueryParam("skip", String.valueOf(skip), false);
        }
        return this.serviceClient.listMetrics(requestOptions).mapPage(bodyItemValue -> (ExperimentMetric)bodyItemValue.toObject(ExperimentMetric.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ExperimentMetric> listMetrics() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listMetrics(requestOptions).mapPage(bodyItemValue -> (ExperimentMetric)bodyItemValue.toObject(ExperimentMetric.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExperimentMetric> createOrUpdateMetricWithResponse(String experimentMetricId, ExperimentMetric resource, RequestOptions requestOptions) {
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, true);
        BinaryData resourceInBinaryData = BinaryData.fromObject((Object)resource);
        resourceInBinaryData.getLength();
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, false);
        Response<BinaryData> response = this.createOrUpdateMetricWithResponse(experimentMetricId, resourceInBinaryData, requestOptions);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((ExperimentMetric)((BinaryData)response.getValue()).toObject(ExperimentMetric.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric createMetric(String experimentMetricId, ExperimentMetric resource) {
        return this.createOrUpdateMetric(experimentMetricId, resource, new RequestConditions().setIfNoneMatch(ETag.ALL.toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExperimentMetric> createMetricWithResponse(String experimentMetricId, ExperimentMetric resource, RequestOptions requestOptions) {
        requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ETag.ALL.toString());
        return this.createOrUpdateMetricWithResponse(experimentMetricId, resource, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric updateMetric(String experimentMetricId, ExperimentMetric resource, String ifMatch) {
        return this.createOrUpdateMetric(experimentMetricId, resource, new RequestConditions().setIfMatch(ifMatch));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric updateMetric(String experimentMetricId, ExperimentMetric resource) {
        return this.updateMetric(experimentMetricId, resource, ETag.ALL.toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExperimentMetric> updateMetricWithResponse(String experimentMetricId, ExperimentMetric resource, RequestOptions requestOptions) {
        return this.createOrUpdateMetricWithResponse(experimentMetricId, resource, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric activateMetric(String experimentMetricId, String ifMatch) {
        return this.updateMetric(experimentMetricId, new ExperimentMetric().setLifecycle(LifecycleStage.ACTIVE), ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric activateMetric(String experimentMetricId) {
        return this.activateMetric(experimentMetricId, ETag.ALL.toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExperimentMetric> activateMetricWithResponse(String experimentMetricId, RequestOptions requestOptions) {
        ExperimentMetric resource = new ExperimentMetric().setLifecycle(LifecycleStage.ACTIVE);
        return this.updateMetricWithResponse(experimentMetricId, resource, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric deactivateMetric(String experimentMetricId, String ifMatch) {
        return this.updateMetric(experimentMetricId, new ExperimentMetric().setLifecycle(LifecycleStage.INACTIVE), ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExperimentMetric deactivateMetric(String experimentMetricId) {
        return this.deactivateMetric(experimentMetricId, ETag.ALL.toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExperimentMetric> deactivateMetricWithResponse(String experimentMetricId, RequestOptions requestOptions) {
        ExperimentMetric resource = new ExperimentMetric().setLifecycle(LifecycleStage.INACTIVE);
        return this.updateMetricWithResponse(experimentMetricId, resource, requestOptions);
    }
}

