/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.onlineexperimentation;

import com.azure.analytics.onlineexperimentation.OnlineExperimentationClientBuilder;
import com.azure.analytics.onlineexperimentation.implementation.JsonMergePatchHelper;
import com.azure.analytics.onlineexperimentation.implementation.OnlineExperimentationClientImpl;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetric;
import com.azure.analytics.onlineexperimentation.models.ExperimentMetricValidationResult;
import com.azure.analytics.onlineexperimentation.models.LifecycleStage;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.ETag;
import com.azure.core.util.FluxUtil;
import java.time.OffsetDateTime;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=OnlineExperimentationClientBuilder.class, isAsync=true)
public final class OnlineExperimentationAsyncClient {
    private final OnlineExperimentationClientImpl serviceClient;

    OnlineExperimentationAsyncClient(OnlineExperimentationClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMetricWithResponse(String experimentMetricId, RequestOptions requestOptions) {
        return this.serviceClient.getMetricWithResponseAsync(experimentMetricId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateMetricWithResponse(String experimentMetricId, BinaryData resource, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateMetricWithResponseAsync(experimentMetricId, resource, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> validateMetricWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.validateMetricWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteMetricWithResponse(String experimentMetricId, RequestOptions requestOptions) {
        return this.serviceClient.deleteMetricWithResponseAsync(experimentMetricId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMetrics(RequestOptions requestOptions) {
        return this.serviceClient.listMetricsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> getMetric(String experimentMetricId, RequestConditions requestConditions) {
        OffsetDateTime ifModifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        OffsetDateTime offsetDateTime = ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        return this.getMetricWithResponse(experimentMetricId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ExperimentMetric)protocolMethodData.toObject(ExperimentMetric.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> getMetric(String experimentMetricId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getMetricWithResponse(experimentMetricId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ExperimentMetric)protocolMethodData.toObject(ExperimentMetric.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> createOrUpdateMetric(String experimentMetricId, ExperimentMetric resource, RequestConditions requestConditions) {
        OffsetDateTime ifModifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        OffsetDateTime offsetDateTime = ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, true);
        BinaryData resourceInBinaryData = BinaryData.fromObject((Object)resource);
        resourceInBinaryData.getLength();
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, false);
        return this.createOrUpdateMetricWithResponse(experimentMetricId, resourceInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ExperimentMetric)protocolMethodData.toObject(ExperimentMetric.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> createOrUpdateMetric(String experimentMetricId, ExperimentMetric resource) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, true);
        BinaryData resourceInBinaryData = BinaryData.fromObject((Object)resource);
        resourceInBinaryData.getLength();
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, false);
        return this.createOrUpdateMetricWithResponse(experimentMetricId, resourceInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ExperimentMetric)protocolMethodData.toObject(ExperimentMetric.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetricValidationResult> validateMetric(ExperimentMetric body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.validateMetricWithResponse(BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ExperimentMetricValidationResult)protocolMethodData.toObject(ExperimentMetricValidationResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteMetric(String experimentMetricId, RequestConditions requestConditions) {
        OffsetDateTime ifModifiedSince;
        RequestOptions requestOptions = new RequestOptions();
        String ifMatch = requestConditions == null ? null : requestConditions.getIfMatch();
        String ifNoneMatch = requestConditions == null ? null : requestConditions.getIfNoneMatch();
        OffsetDateTime ifUnmodifiedSince = requestConditions == null ? null : requestConditions.getIfUnmodifiedSince();
        OffsetDateTime offsetDateTime = ifModifiedSince = requestConditions == null ? null : requestConditions.getIfModifiedSince();
        if (ifMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        }
        if (ifNoneMatch != null) {
            requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ifNoneMatch);
        }
        if (ifUnmodifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_UNMODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifUnmodifiedSince)));
        }
        if (ifModifiedSince != null) {
            requestOptions.setHeader(HttpHeaderName.IF_MODIFIED_SINCE, String.valueOf(new DateTimeRfc1123(ifModifiedSince)));
        }
        return this.deleteMetricWithResponse(experimentMetricId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteMetric(String experimentMetricId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteMetricWithResponse(experimentMetricId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ExperimentMetric> listMetrics(Integer top, Integer skip) {
        RequestOptions requestOptions = new RequestOptions();
        if (top != null) {
            requestOptions.addQueryParam("top", String.valueOf(top), false);
        }
        if (skip != null) {
            requestOptions.addQueryParam("skip", String.valueOf(skip), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listMetrics(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (ExperimentMetric)protocolMethodData.toObject(ExperimentMetric.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ExperimentMetric> listMetrics() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listMetrics(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (ExperimentMetric)protocolMethodData.toObject(ExperimentMetric.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExperimentMetric>> createOrUpdateMetricWithResponse(String experimentMetricId, ExperimentMetric resource, RequestOptions requestOptions) {
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, true);
        BinaryData resourceInBinaryData = BinaryData.fromObject((Object)resource);
        resourceInBinaryData.getLength();
        JsonMergePatchHelper.getExperimentMetricAccessor().prepareModelForJsonMergePatch(resource, false);
        return this.createOrUpdateMetricWithResponse(experimentMetricId, resourceInBinaryData, requestOptions).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((ExperimentMetric)((BinaryData)response.getValue()).toObject(ExperimentMetric.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> createMetric(String experimentMetricId, ExperimentMetric resource) {
        return this.createOrUpdateMetric(experimentMetricId, resource, new RequestConditions().setIfNoneMatch(ETag.ALL.toString()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExperimentMetric>> createMetricWithResponse(String experimentMetricId, ExperimentMetric resource) {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHeader(HttpHeaderName.IF_NONE_MATCH, ETag.ALL.toString());
        return this.createOrUpdateMetricWithResponse(experimentMetricId, resource, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> updateMetric(String experimentMetricId, ExperimentMetric resource, String ifMatch) {
        return this.createOrUpdateMetric(experimentMetricId, resource, new RequestConditions().setIfMatch(ifMatch));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExperimentMetric>> updateMetricWithResponse(String experimentMetricId, ExperimentMetric resource, String ifMatch) {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHeader(HttpHeaderName.IF_MATCH, ifMatch);
        return this.createOrUpdateMetricWithResponse(experimentMetricId, resource, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> updateMetric(String experimentMetricId, ExperimentMetric resource) {
        return this.updateMetric(experimentMetricId, resource, ETag.ALL.toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExperimentMetric>> updateMetricWithResponse(String experimentMetricId, ExperimentMetric resource) {
        return this.updateMetricWithResponse(experimentMetricId, resource, ETag.ALL.toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> activateMetric(String experimentMetricId, String ifMatch) {
        return this.updateMetric(experimentMetricId, new ExperimentMetric().setLifecycle(LifecycleStage.ACTIVE), ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExperimentMetric>> activateMetricWithResponse(String experimentMetricId, String ifMatch) {
        ExperimentMetric resource = new ExperimentMetric().setLifecycle(LifecycleStage.ACTIVE);
        return this.updateMetricWithResponse(experimentMetricId, resource, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> activateMetric(String experimentMetricId) {
        return this.activateMetric(experimentMetricId, ETag.ALL.toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExperimentMetric>> activateMetricWithResponse(String experimentMetricId) {
        return this.activateMetricWithResponse(experimentMetricId, ETag.ALL.toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> deactivateMetric(String experimentMetricId, String ifMatch) {
        return this.updateMetric(experimentMetricId, new ExperimentMetric().setLifecycle(LifecycleStage.INACTIVE), ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExperimentMetric>> deactivateMetricWithResponse(String experimentMetricId, String ifMatch) {
        ExperimentMetric resource = new ExperimentMetric().setLifecycle(LifecycleStage.INACTIVE);
        return this.updateMetricWithResponse(experimentMetricId, resource, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExperimentMetric> deactivateMetric(String experimentMetricId) {
        return this.deactivateMetric(experimentMetricId, ETag.ALL.toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExperimentMetric>> deactivateMetricWithResponse(String experimentMetricId) {
        return this.deactivateMetricWithResponse(experimentMetricId, ETag.ALL.toString());
    }
}

